% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparseConstraints.R
\name{sparseConstraints}
\alias{print.sparseConstraints}
\alias{sparseConstraints}
\alias{sparseConstraints.data.frame}
\title{Generate sparse set of constraints.}
\usage{
sparseConstraints(object, ...)

\method{sparseConstraints}{data.frame}(object, b, neq = length(b),
  base = 1L, sorted = FALSE, ...)

\method{print}{sparseConstraints}(x, range = 1L:10L, ...)
}
\arguments{
\item{object}{R object to be translated to sparseConstraints format.}

\item{...}{options to be passed to other methods}

\item{b}{Constant vector}

\item{neq}{The first \code{new} equations are interpreted as equality constraints, the rest as '<='}

\item{base}{are the indices in \code{object[,1:2]} base 0 or base 1?}

\item{sorted}{is \code{object} sorted by the  first column?}

\item{x}{an object of class \code{sparseConstraints}}

\item{range}{integer vector stating which constraints to print}
}
\value{
Object of class \code{sparseConstraints} (see details).
}
\description{
Generate a constraint set to be used by \code{\link{sparse_project}}

Read sparse constraints from a \code{data.frame}

Print sparseConstraints object
}
\section{Details}{


The \code{sparseConstraints} objects holds coefficients of
\eqn{\boldsymbol{A}} and \eqn{\boldsymbol{b}} of the system
\eqn{\boldsymbol{Ax}\leq \boldsymbol{b}} in sparse format, outside of
\code{R}'s memory. It can be reused to find solutions for vectors to adjust.

In \code{R}, it is a \emph{reference object}. In particular, it is meaningless to
\itemize{
   \item{Copy the object. You only will only generate a pointer to physically the same object.}
   \item{Save the object. The physical object is destroyed when \code{R} closes, or when \code{R}'s
     garbage collector cleans up a removed \code{sparseConstraints} object.}
}
}

\section{The \code{$project} method}{


Once a \code{sparseConstraints} object \code{sc} is created, you can reuse it to optimize
several vectors by calling \code{sc$project()} with the following parameters:
\itemize{
  \item{\code{x}: \code{[numeric]} the vector to be optimized}
  \item{\code{w}: \code{[numeric]} the weight vector (of \code{length(x)}). By default all weights equal 1.}
  \item{\code{eps}: \code{[numeric]} desired tolerance. By default \eqn{10^{-2}} }
  \item{\code{maxiter}: \code{[integer]} maximum number of iterations. By default 1000.}
}
The return value of \code{$spa} is the same as that of \code{\link{sparse_project}}.
}
\examples{

# The following system of constraints, stored in
# row-column-coefficient format
#
# x1 + x8 ==  950,
# x3 + x4 ==  950 ,
# x6 + x7 == x8,
# x4 > 0
# 
A <- data.frame( 
   row = c( 1, 1, 2, 2, 3, 3, 3, 4)
   , col = c( 1, 2, 3, 4, 2, 5, 6, 4)
   , coef = c(-1,-1,-1,-1, 1,-1,-1,-1)
)
b <- c(-950, -950, 0,0) 

sc <- sparseConstraints(A, b, neq=3)

# Adjust the 0-vector minimally so all constraints are met:
sc$project(x=rep(0,8))

# Use the same object to adjust the 100*1-vector
sc$project(x=rep(100,8))

# use the same object to adjust the 0-vector, but with different weights
sc$project(x=rep(0,8),w=1:8)


}
\seealso{
\code{\link{sparse_project}}, \code{\link{project}}
}

