% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenarios.R
\name{bsSVM}
\alias{bsSVM}
\title{Bootstrap}
\usage{
bsSVM(x, y, ..., solver, ws.number = 5, ws.size = 500, do.select = TRUE)
}
\arguments{
\item{x}{either a formula or the features}

\item{y}{either the data or the labels corresponding to the features \code{x}.
It can be a \code{character} in which case the data is loaded using \code{\link{liquidData}}.
If it is of type \code{liquidData} then after \code{train}ing and \code{select}ion
the model is \code{\link{test}}ed using the testing data (\code{y$test}).}

\item{...}{configuration parameters, see \link{Configuration}. Can be \code{threads=2, display=1, gpus=1,} etc.}

\item{solver}{the solver to use. Can be any of \code{KERNEL_RULE}, \code{SVM_LS_2D},
\code{SVM_HINGE_2D}, \code{SVM_QUANTILE}, \code{SVM_EXPECTILE_2D}}

\item{ws.number}{number of working sets to build and train}

\item{ws.size}{how many samples to draw from the training set for each working set}

\item{do.select}{if \code{TRUE} also does the whole selection for this model}
}
\value{
an object of type \code{svm}. Depending on the usage this object
has also \code{$train_errors}, \code{$select_errors}, and \code{$last_result}
properties.
}
\description{
This routine performs bootstrap learning for all scenarios except multiclass classification.
}

