#' Junior school project data
#' 
#' A dataset containing 728 students from 50 primary (elementary) schools in inner 
#' Londan that were part of the Junior School Project (JSP). The variables are
#' as follows:
#' \itemize{
#'  \item mathAge11: score on Maths at age 11
#'  \item mathAge8: score on Maths at age 8
#'  \item gender: gender, a factor with 2 levels (F, M)
#'  \item class: father's social class, a factor with 2 levels (manual, nonmanual)
#'  \item shool: school code (1-50)
#'  \item normAge11: normalized score on Maths at age 11
#'  \item normAge8: normalized score on Maths at age 8
#'  \item schoolMathAge8: average school Maths score
#'  \item mathAge8c: centered Maths score at age 8
#' }
#' 
#' @docType data
#' @keywords datasets
#' @name jsp728
#' @usage data(jsp728)
#' @format A data frame with 728 rows and 8 variables.
#' @source \url{http://www.bristol.ac.uk/cmm/team/hg/msm-3rd-ed/datasets.html}
#' @references 
#'   Goldstein, H. (2011). Multilevel Statistical Models (4th ed.). Hoboken: Wiley
NULL