% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pel.R
\name{pel}
\alias{pel}
\alias{pel_x}
\alias{pel_lmom}
\title{Generic function for \code{\link{pel...}}}
\usage{
pel(
  distrib = c("exp", "gam", "gev", "glo", "gpa", "gno", "gum", "kap", "ln3", "nor",
    "pe3", "wak", "wei"),
  lmom = NULL,
  probability_distribution_attrname = "probability_distrib",
  x = NULL,
  nmom = 5,
  sort.data = TRUE,
  ratios = sort.data,
  trim = 0,
  indices = NULL,
  spi.scale = NA,
  correction = NULL,
  ...
)

pel_x(x, ...)

pel_lmom(lmom, ...)
}
\arguments{
\item{distrib}{character string incating the probability distribution to fit}

\item{lmom, ...}{L-moments and further parameters for \code{\link{pel...}}}

\item{probability_distribution_attrname}{attribute name for probability distribution}

\item{x}{vector containg sample. It is utiled to calculete L-moments in case \code{lmom} is set equal to \code{NULL}.}

\item{nmom, sort.data, ratios, trim}{arguments for \code{\link{samlmu}} (\code{nmom=5} by default). Thay are utilized if argument \code{lmom} is \code{NULL}.}

\item{indices}{optional index or tag character vector of the same length of \code{x} used as INDEX for \code{\link{tapply}}. It is used to fit different probability distribution in one sample time series (e. g. months in an year).}

\item{spi.scale}{integer value or \code{NA}. If it is greater than 1, \code{x} is filtered with the sum of a generic element of \code{x} and the previous \code{spi.scale-1} ones (e.g. SPI-3,SPI-6, etc. ). Default is \code{NA} (no filtering) which is equivalent to \code{spi.scale=1}.}

\item{correction}{numeric value correction for the 3rd (and higher) L-moment estimation. Default is \code{NULL} , generally it is not used. It is used and suggested to be \code{10^(-10)} in case of a massive function use with \code{lmom=NULL} (e.g. raster cell or zonal statistics).}
}
\value{
A numeric vector containing the  parameters of the selected probability distribution. It is a list in case of selection of several probability distributions (i.e. \code{length(distrib)>1}).
}
\description{
Generic function for \code{\link{pel...}}: probability distribution fitting with L-Moments
}
\details{
\code{pel_x} and \code{pel_lmom} are wrapper functions of \code{\link{pel}} whose first argument is \code{x} or \code{lmom} respectively.
}
\examples{

 # Sample L-moments of Ozone from the airquality data
 data(airquality)
 lmom <- samlmu(airquality$Ozone,nmom=6)
 distrib <- "gev"    
 # Fit a GEV distribution
 out_gev <- pel(distrib=distrib,lmom=lmom)

 distrib <- c("exp","gam","gev","glo","gpa","gno","gum","kap","ln3",
 "nor","pe3","wak","wei")

 out_list <- pel(distrib=distrib,lmom=lmom)
 \donttest{
 library(rasterList)
 precff <- system.file("map/Mekrou_precipitation.grd", package="rasterList")
	precs <- stack(precff)
 prec_point <- precs[143][,]
 ## month index 
 month <- as.character(as.Date(names(prec_point),format="X\%Y.\%m.\%d"),format="M\%m")
 distrib_prec <- c("gam","pe3")
 out_x <- pel(x=prec_point,indices=month,distrib=distrib_prec)
 out_spi3_x <- pel(x=prec_point,indices=month,distrib=distrib_prec,spi.scale=3)
 distrib_prec2 <- c("gam")
 out_x <- pel(x=prec_point,indices=month,distrib=distrib_prec2)
 out_spi3_x <- pel(x=prec_point,indices=month,distrib=distrib_prec2,spi.scale=3)

 ### example with PEL when x is always 0 or a fixed constant
 xx <- array(0,50)
 out_xx <- pel_x(x=xx,distrib=distrib_prec2)
 }


}
\seealso{
\code{\link{pel...}},\code{\link{pelexp}},\code{\link{pelgam}},\code{\link{pelgev}},\code{\link{pelglo}},\code{\link{pelgpa}},

\code{\link{pelgno}},\code{\link{pelgum}},\code{\link{pelkap}},\code{\link{pelln3}},\code{\link{pelnor}},

\code{\link{pelpe3}},\code{\link{pelwak}},\code{\link{pelwei}},

\code{\link{cdf}},\code{\link{qua}}
}
