"pdfemu" <-
function(x, para, paracheck=TRUE) {
   if(paracheck == TRUE) {
      if(! are.paremu.valid(para)) return()
   }

   SMALL <- 1E-6

   E <- para$para[1]
   M <- para$para[2]
   h <- 1 / (1-E^2)
   H <- E / (1-E^2)
   nu <- M - 1/2
   nu.is.negative.integer <- FALSE
   if(nu < 0) {
     if(as.integer(nu) == nu) nu.is.negative.integer <- TRUE
   }

   f <- vector(mode="numeric", length=length(x))
   for(i in seq(1,length(x))) {
     xi  <- x[i]
     if(is.na(xi) || xi < 0) { f[i] <- NA; next }
     if(! is.finite(xi)) { f[i] <- 0; next }
     xx <- xi^2
     if(E <= SMALL) { # eta going to zero
        f[i] <- 2*(2*M)^(2*M) / gamma(2*M) * xi^(2*(2*M) - 1) * exp(-2*M*xx)
     } else {
        #message("Other ")
        toI <- 2*M*H*xx
        tmpB <- 4*sqrt(pi)*M^(M+1/2)*h^M  / ( gamma(M)*H^nu )
        tmpB <- tmpB * xi^(2*M) * exp(-2*M*h*xx)
        B <- besselI(toI, nu=nu)
        #message("X      ",xi)
        #message("toI    ",toI)
        #message("tmpB   ",tmpB)
        #message("B      ",B,"\n")
        if(is.finite(B) & tmpB != 0) { # eta going to +/- unity
          f[i] <- tmpB * B
        } else {
          f[i] <- 2*M^M / gamma(M) * xi^(2*M-1) * exp(-M*xx)
        }
    }
   }
   return(f)
}

