% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_sigma_names.R
\name{beta_sigma_names}
\alias{beta_sigma_names}
\title{Unique names for beta_sigma}
\usage{
beta_sigma_names(beta_mu_names, beta_sigma_names, ...)
}
\arguments{
\item{beta_mu_names}{Character vector with the names of the coefficients \eqn{\beta_\mu}}

\item{beta_sigma_names}{Character vector with the names of the coefficients \eqn{\beta_\sigma}}

\item{...}{Additional arguments, not used in the current implementation}
}
\value{
Named character vector with the names of the coefficients \eqn{\beta_\sigma}. The name of a vector element
is the original
name of the coefficient. The value is the adapted name. The name and the value are equal if no adaptation was needed.
}
\description{
Returns adapted names for the coefficients \eqn{\beta_\sigma} to distinguish them from the names
of the coefficients
\eqn{\beta_\mu}. This is a helper function which is used in situations where it is necessary or convenient
for the coefficient names of \eqn{\beta_\sigma}
to be different from \eqn{\beta_\mu}.
}
\details{
When the name of at least one coefficient in \eqn{\beta_\sigma} is equal to one of the names of the
coefficients in \eqn{\beta_\mu}, the string '_s' is
appended to the names of all coefficients in \eqn{\beta_\sigma}.
Otherwise, the names of the coefficients in \eqn{\beta_\sigma} are left unchanged.
}
\examples{
# If the names in beta_sigma are all different from all of the names in
# beta_mu, the function returns the names of beta_sigma
mu_names = c("(Intercept)", "age", "gender")
sigma_names = c("(Intercept_s)", "smoker", "job_code")

beta_sigma_names(mu_names, sigma_names)

# If at least one of the names in beta_sigma is equal to a name in
# beta_mu, all the names in beta_sigma get the string '_s' appended,
# except for '(intercept_s)'
sigma_names = c("(Intercept_s)", "age", "job_code")

beta_sigma_names(mu_names, sigma_names)
}
