% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergence_precheck.R
\name{convergence_precheck}
\alias{convergence_precheck}
\title{Pre-check model matrices for convergence issues}
\usage{
convergence_precheck(y, X_mu, X_sigma)
}
\arguments{
\item{y}{Numeric, response vector y}

\item{X_mu}{Model matrix for the expected values}

\item{X_sigma}{Model matrix for the standard deviations. This must be a full-rank matrix.}
}
\value{
A list with the following members:
\itemize{
\item \code{column_numbers} The numbers of the columns of \code{X_sigma} that can be kept
\item \code{column_names} The names of the columns of \code{X_sigma} that can be kept
}
Numbers and names refer to the same columns. They are supplied both for convenience.
}
\description{
The model matrices \eqn{X_\mu} and \eqn{X_\sigma} are checked to see if problems
with the convergence of the fit can be anticipated. If so, it is determined which columns
must be removed from \eqn{X_\sigma} to attempt to avoid convergence issues.
}
\details{
A matrix can be of class 'matrix',
'Matrix' or 'numeric' (in case it is a matrix of one column only).

An intercept term must be included in the model matrices if the model is such.
}
