% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_lm_loglik.R
\name{plot_lm_loglik}
\alias{plot_lm_loglik}
\title{Plot of the log-likelihood surface of a lineair model}
\usage{
plot_lm_loglik(y, X, beta_or, beta_x, beta_y, add_qa = FALSE,
  plot_width = 3, plot_points = 20)
}
\arguments{
\item{y}{Vector of observations}

\item{X}{Model matrix}

\item{beta_or}{Vector of beta values around which the plot is centered. Also the origin of the quadratic appriximation.}

\item{beta_x}{Component of beta to be plotted at the x-axis. Can be an index of \code{beta_or} or a name in case \code{beta_or}
is a named vector}

\item{beta_y}{Component of beta to be plotted at the y-axis. Can be an index of \code{beta_or} or a name in case \code{beta_or}
is a named vector}

\item{add_qa}{Boolean, specifies whether or not a quadratic approximation of the maximum log-likelihood
surface is plotted}

\item{plot_width}{Single numeric value, half the range of x- and y-values}

\item{plot_points}{Integer, number of points in the x- and y-dimension at which the maximum-likelihood surface is calculated.}
}
\description{
Creates a 3-d plot of the maximum log-likelihood of a lineair model. The maximum log-likelihood is plotted as a function
of two elements of the parameter vector \eqn{\beta}. Optionally, the maximum of a quadratic approximation to the log-likelihood
surface is plotted.

This function is intended for development purposes only.
}
\details{
The function plots the maximum log-likelihood of linear model as a function of two components of the vector \eqn{\beta}.
Optionally, it also plots a quadratic approximation to the log-likelihood and plot its maximum.

The quadratic approximation is defined as

\eqn{log L_q (\beta) = log L(\beta_o) + g (\beta - \beta_o)  + 0.5 (\beta - \beta_o) H (\beta - \beta_o)}

where \eqn{log L_q} is the quadratic approximation of the log-likelihood, \eqn{\beta_o} the value of \eqn{\beta} at the origin, \eqn{g}
the gradient and \eqn{H} the Hessian of the log-likelihood at \eqn{\beta_o}.

For each point \eqn{(\beta_x, \beta_y)}, the other components of the vector \eqn{\beta} are chosen such that the log-likelihood
is at its maximum. This maximum is plotted.

The same is true for a quadratic approximation of the log-likelihood, except when it has no maximum (i.e. the Hessian
\eqn{H} is not negative-definite at \eqn{\beta_o}). In that case, a waning is issued and
the other components of \eqn{\beta} are set to the value they have in \code{beta_or}. The resulting quadratic approximation is plotted.
This does not affect the plot of the maximum of the true log-likelihood.

To create the plot, the package \code{plotly} needs to be installed. A warning is issued if that is not the case.
}
\examples{
\dontrun{

# Carry out a linear regression with the 'iris' data set
fit = lm( Petal.Length ~ Species, data = iris, x = TRUE, y = TRUE)
X = fit$x
y = fit$y

# We center the plot at the maximum-likelihood
beta_or = coef(fit)

# Plot the maximum log-likelihood
lmvar:::plot_lm_loglik( y, X, beta_or = beta_or, beta_x = "(Intercept)",
                        beta_y = "Speciesversicolor")

# Plot against the two species
lmvar:::plot_lm_loglik( y, X, beta_or = beta_or, beta_x = "Speciesversicolor",
                        beta_y = "Speciesvirginica")

# Increase the resolution
lmvar:::plot_lm_loglik( y, X, beta_or = beta_or, beta_x = "Speciesversicolor",
                        beta_y = "Speciesvirginica", plot_points = 40)

# Remove the intercept term from the model matrix and fit again
XX = X[,-1]
fit = lm( y ~ . - 1, data = as.data.frame(XX))

# Estimate the effect of adding an intercept term in a quadratic approximation and compare
# with exact result
beta_or = c( 0, coef(fit))
lmvar:::plot_lm_loglik( y, X, beta_or = beta_or, beta_x = 1, beta_y = "Speciesversicolor",
                        add_qa = TRUE, plot_points = 40, plot_width = 5)

# Note that in the last case the quadratic approximation has no maximum. Hence the beta for
# "Speciesvirginica" is kept at beta_or[3] in the calculation of the surface of the
# quadratic approximation.
}
}
