% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{karlin}
\alias{karlin}
\title{Karlin [p-value] [iid]}
\usage{
karlin(
  localScore,
  sequence_length,
  score_probabilities,
  sequence_min,
  sequence_max
)
}
\arguments{
\item{localScore}{the observed local score}

\item{sequence_length}{length of the sequence (at least several hundreds)}

\item{score_probabilities}{the probabilities for each unique score from lowest to greatest}

\item{sequence_min}{minimum score}

\item{sequence_max}{maximum score}
}
\value{
A double representing the probability of a localScore as high as the one given as argument
}
\description{
Calculates an approximated p-value of a given local score value and a long sequence length in the identically and independantly distributed model for the sequence. See also mcc() function for another approximated method in the i.i.d. model
}
\details{
This method works the better the longer the sequence is.
}
\examples{
karlin(150, 10000, c(0.08, 0.32, 0.08, 0.00, 0.08, 0.00, 0.00, 0.08, 0.02, 0.32, 0.02), -5, 5)
}
