\name{plot.eval}
\alias{plot.eval}
\title{
Plot evaluation points from a 2-d locfit object.
}
\usage{
plot.eval(x, add=FALSE, text=FALSE, ...)
}
\description{
This function is used to plot the evaluation structure generated by
Locfit for a two dimensional fit. Vertices of the tree structure are
displayed as \code{O}; pseudo-vertices as \code{*}.
}
\arguments{
\item{x}{\code{"locfit"} object. }
\item{add}{If \code{TRUE}, add to existing plot.}
\item{text}{If \code{TRUE}, numbers will be added indicating the order points
  were added.}
\item{...}{Arguments passed to and from other methods.}
}
\examples{
data(ethanol, package="locfit")
fit <- locfit(NOx ~ E + C, data=ethanol, scale=0)
plot.eval(fit)
}
\seealso{
\code{\link{locfit}}.
}
\keyword{smooth}
