% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_plot.R
\name{line_plot}
\alias{line_plot}
\title{Locus line plot}
\usage{
line_plot(
  loc,
  pcutoff = 5e-08,
  xlab = NULL,
  ylab = expression("-log"[10] ~ "P"),
  cex.axis = 1,
  xticks = FALSE,
  border = FALSE,
  align = TRUE,
  ...
)
}
\arguments{
\item{loc}{Object of class 'locus' to use for plot. See \link{locus}.}

\item{pcutoff}{Cut-off for p value significance. Defaults to p = 5e-08. Set
to \code{NULL} to disable.}

\item{xlab}{x axis title.}

\item{ylab}{y axis title.}

\item{cex.axis}{Specifies font size for axis numbering.}

\item{xticks}{Logical whether x axis numbers and axis title are plotted.}

\item{border}{Logical whether a bounding box is plotted around upper and
lower plots.}

\item{align}{Logical whether set \code{\link[=par]{par()}} to align the plot.}

\item{...}{Other arguments passed to \code{\link[=plot]{plot()}} for the scatter plot.}
}
\value{
No return value. Produces a scatter plot using base graphics.
}
\description{
Produces a line plot from a 'locus' class object. Intended for use with
\code{\link[=set_layers]{set_layers()}}.
}
\seealso{
\code{\link[=locus]{locus()}} \code{\link[=set_layers]{set_layers()}} \code{\link[=scatter_plot]{scatter_plot()}}
}
