% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locus_ggplot.R
\name{locus_ggplot}
\alias{locus_ggplot}
\title{Locus plot using ggplot2}
\usage{
locus_ggplot(
  loc,
  heights = c(3, 2),
  filter_gene_name = NULL,
  filter_gene_biotype = NULL,
  border = FALSE,
  cex.axis = 1,
  cex.lab = 1,
  cex.text = 0.7,
  gene_col = ifelse(showExons, "blue4", "skyblue"),
  exon_col = "blue4",
  exon_border = "blue4",
  showExons = TRUE,
  maxrows = 12,
  text_pos = "top",
  xticks = "top",
  xlab = NULL,
  highlight = NULL,
  highlight_col = "red",
  blanks = "fill",
  ...
)
}
\arguments{
\item{loc}{Object of class 'locus' to use for plot. See \code{\link[=locus]{locus()}}.}

\item{heights}{Vector supplying the ratio of top to bottom plot.}

\item{filter_gene_name}{Vector of gene names to display.}

\item{filter_gene_biotype}{Vector of gene biotypes to be filtered. Use
\code{\link[ensembldb:EnsDb-class]{ensembldb::listGenebiotypes()}} to display possible biotypes. For example,
\code{ensembldb::listGenebiotypes(EnsDb.Hsapiens.v75)}}

\item{border}{Logical whether a bounding box is plotted.}

\item{cex.axis}{Specifies font size for axis numbering.}

\item{cex.lab}{Specifies font size for axis titles.}

\item{cex.text}{Font size for gene text.}

\item{gene_col}{Colour for gene lines.}

\item{exon_col}{Fill colour for exons.}

\item{exon_border}{Border line colour outlining exons (or genes if
\code{showExons} is \code{FALSE}). Set to \code{NA} for no border.}

\item{showExons}{Logical whether to show exons or simply show whole gene as a
rectangle. If \code{showExons = FALSE} colours are specified by \code{exon_border}
for rectangle border and \code{gene_col} for the fill colour.}

\item{maxrows}{Specifies maximum number of rows to display in gene annotation
panel.}

\item{text_pos}{Character value of either 'top' or 'left' specifying
placement of gene name labels.}

\item{xticks}{Logical whether x axis ticks and numbers are plotted.}

\item{xlab}{Title for x axis. Defaults to chromosome \code{seqname} specified in
\code{locus}.}

\item{highlight}{Vector of genes to highlight.}

\item{highlight_col}{Single colour or vector of colours for highlighted
genes.}

\item{blanks}{Controls handling of genes with blank names: \code{"fill"} replaces
blank gene symbols with ensembl gene ids. \code{"hide"} hides genes which are
missing gene symbols.}

\item{...}{Additional arguments passed to \code{\link[=gg_scatter]{gg_scatter()}} to control
the scatter plot.}
}
\value{
Returns a ggplot2 plot containing a scatter plot with genetracks
underneath.
}
\description{
Genomic locus plot similar to locuszoom.
}
\details{
Arguments to control plotting of the gene tracks are passed onto
\code{\link[=gg_genetracks]{gg_genetracks()}} and for the scatter plot are passed via \code{...} to
\code{\link[=gg_scatter]{gg_scatter()}}. See the documentation for each of these functions for
details.
}
\examples{
if(require(EnsDb.Hsapiens.v75)) {
data(SLE_gwas_sub)
loc <- locus(SLE_gwas_sub, gene = 'IRF5', flank = c(7e4, 2e5), LD = "r2",
             ens_db = "EnsDb.Hsapiens.v75")
locus_ggplot(loc)
}
}
\seealso{
\code{\link[=gg_scatter]{gg_scatter()}} \code{\link[=gg_genetracks]{gg_genetracks()}}
}
