% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locus_plotly.R
\name{locus_plotly}
\alias{locus_plotly}
\title{Locus plotly}
\usage{
locus_plotly(
  loc,
  heights = c(0.6, 0.4),
  filter_gene_name = NULL,
  filter_gene_biotype = NULL,
  cex.text = 0.7,
  gene_col = ifelse(showExons, "blue4", "skyblue"),
  exon_col = "blue4",
  exon_border = "blue4",
  showExons = TRUE,
  maxrows = 8,
  width = 600,
  xlab = NULL,
  blanks = "show",
  ...
)
}
\arguments{
\item{loc}{Object of class 'locus' to use for plot. See \code{\link[=locus]{locus()}}.}

\item{heights}{Vector controlling relative height of each panel on 0-1 scale.
Alternatively a vector of length 2 of height in pixels passed to
\code{scatter_plotly()} and \code{genetrack_ly()}.}

\item{filter_gene_name}{Vector of gene names to display.}

\item{filter_gene_biotype}{Vector of gene biotypes to be filtered. Use
\code{\link[ensembldb:EnsDb-class]{ensembldb::listGenebiotypes()}} to display possible biotypes. For example,
\code{ensembldb::listGenebiotypes(EnsDb.Hsapiens.v75)}}

\item{cex.text}{Font size for gene text.}

\item{gene_col}{Colour for gene lines.}

\item{exon_col}{Fill colour for exons.}

\item{exon_border}{Border line colour outlining exons (or genes if
\code{showExons} is \code{FALSE}). Set to \code{NA} for no border.}

\item{showExons}{Logical whether to show exons or simply show whole gene as a
rectangle. If \code{showExons = FALSE} colours are specified by \code{exon_border}
for rectangle border and \code{gene_col} for the fill colour.}

\item{maxrows}{Specifies maximum number of rows to display in gene
annotation panel.}

\item{width}{Width of plotly plot in pixels which is purely used to prevent
overlapping text for gene names.}

\item{xlab}{Title for x axis. Defaults to chromosome \code{seqname} specified
in \code{locus}.}

\item{blanks}{Controls handling of genes with blank names: \code{"fill"} replaces
blank gene symbols with ensembl gene ids. \code{"hide"} completely hides genes
which are missing gene symbols. \code{"show"} shows gene lines but no label
(hovertext is still available).}

\item{...}{Optional arguments passed to \code{\link[=scatter_plotly]{scatter_plotly()}} to control the
scatter plot.}
}
\value{
A 'plotly' plotting object showing a scatter plot above gene tracks.
}
\description{
Genomic locus plot similar to locuszoom, using plotly.
}
\details{
This is an R/plotly version of locuszoom for exploring regional Manhattan
plots of gene loci. Use \code{\link[=locus]{locus()}} first to generate an object of class
'locus' for plotting. This references a selected Ensembl database for
annotating genes and exons. Hover over the points or gene tracks to reveal
more information.
}
\examples{
if(require(EnsDb.Hsapiens.v75)) {
data(SLE_gwas_sub)
loc <- locus(SLE_gwas_sub, gene = "IRF5", flank = c(7e4, 2e5), LD = "r2",
             ens_db = "EnsDb.Hsapiens.v75")
locus_plotly(loc)
}
}
\seealso{
\code{\link[=locus]{locus()}} \code{\link[=genetrack_ly]{genetrack_ly()}} \code{\link[=scatter_plotly]{scatter_plotly()}}
}
