% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_info.R
\name{l_info_states}
\alias{l_info_states}
\title{Retrieve Information about the States of a Loon Widget}
\usage{
l_info_states(target, states = "all")
}
\arguments{
\item{target}{either an object of class loon or a vector that specifies the
widget, layer, glyph, navigator or context completely. The widget is
specified by the widget path name (e.g. \code{'.l0.plot'}), the remaining
objects by their ids.}

\item{states}{vector with names of states. \code{'all'} is treated as a
keyword and results in returning information on all plot states}
}
\value{
a named nested list with one element per state. The list elements are
  also named lists with \code{type}, \code{dimension}, \code{defaultvalue},
  and \code{description} elements containing the respective information.
}
\description{
Loon's built-in object documentation. Can be used with every
  loon object that has plot states including plots, layers, navigators,
  contexts.  This is a generic function.
}
\examples{
if(interactive()){

p <- l_plot(iris, linkingGroup="iris")
i <- l_info_states(p)
names(p)
names(i)
i$selectBy

l <- l_layer_rectangle(p, x=range(iris[,1]), y=range(iris[,2]), color="")
l_info_states(l)


h <- l_hist(iris$Sepal.Length, linkingGroup="iris")
l_info_states(h)

}
}
\seealso{
Other loon interactive states: 
\code{\link{l_hist}()},
\code{\link{l_plot}()},
\code{\link{l_serialaxes}()},
\code{\link{l_state_names}()},
\code{\link{names.loon}()}
}
\concept{loon interactive states}
