% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsnstat_metadata.R
\name{lsnstat_metadata}
\alias{lsnstat_metadata}
\title{Metadata query function for \link{lsnstat_macrodata} requests.}
\usage{
lsnstat_metadata(dataset, param)
}
\arguments{
\item{dataset}{dataset requested : list available at \url{https://docs.lasocietenouvelle.org/series-donnees} (required)}

\item{param}{list of dataset 'params' available for a dataset (optional)}
}
\value{
A \code{\link[=data.frame]{data.frame()}}.
}
\description{
Metadata query function for \link{lsnstat_macrodata} requests.
}
\examples{

# GET 'CPEB' (Branch production and operations accounts) table parameters and filters.

lsnstat_metadata(dataset = "na_cpeb")

# GET footprints filters for parameter 'indic'.

lsnstat_metadata("macro_fpt_a38",param = "indic")

# GET footprints filters for parameter 'unit'.

lsnstat_metadata("macro_fpt_a38",param = "unit")

# GET 'ERE' (resource-use equilibrium) table parameters and filters.

lsnstat_metadata("na_pat_nf")

}
