% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ltsspca.R
\name{ltsspca}
\alias{ltsspca}
\title{Sparse Principal Component Analysis Based on Least Trimmed Squaers (LTS-SPCA)}
\usage{
ltsspca(x, kmax, alpha = 0.5, mu.choice = NULL, l.search = NULL,
  ls.min = 1, tol = 1e-06, N1 = 3, N2 = 2, N2bis = 10,
  Npc = 10)
}
\arguments{
\item{x}{the input data matrix}

\item{kmax}{the maximal number of PCs searched by the intial LTS-SPCA}

\item{alpha}{the robust parameter which takes value between 0 to 0.5, default is 0.5}

\item{mu.choice}{the center estimate fixed by the user; by default, the center will be estimated automatically by the algorithm}

\item{l.search}{a list of length kmax which contains the search grids chosen by the user; default is NULL}

\item{ls.min}{the smallest grid step when searching for the sparsity of each PC; default is 1}

\item{tol}{convergence criterion}

\item{N1}{the number controls the updates for a without updating b in the concentration step for LTS-PCA}

\item{N2}{the number controls outer loop in the concentration step for LTS-PCA}

\item{N2bis}{the number controls the outer loop for the selected b for both LTS-PCA and LTS-SPCA}

\item{Npc}{the number controls the inner loop for both LTS-PCA and LTS-SPCA}
}
\value{
the object of class "ltsspca" is returned \cr
\item{loadings}{the initially estimated loading matrix by LTS-SPCA}
\item{mu}{the center estimates associated with each PC}
\item{spca.it}{the list that contains the results of LTS-SPCA when searching for the individual PCs}
\item{ls}{the list that contains the final search grid for each PC direction}
}
\description{
the function that computes the initial LTS-SPCA
}
\examples{
library(mvtnorm)
dataM <- dataSim(n = 200, p = 20, bLength = 4, a = c(0.9, 0.5, 0),
                SD = c(10, 5, 2), eps = 0, seed = 123)
x <- dataM$data
ltsspcaMI <- ltsspca(x = x, kmax = 5, alpha = 0.5)
ltsspcaMR <- ltsspcaRw(x = x, obj = ltsspcaMI, k = 2, alpha = 0.5)
matplot(ltsspcaMR$loadings,type="b",ylab="Loadings")
}
\references{
Wang, Y., Van Aelst, S. (2019), `` Sparse Principal Component Based On Least Trimmed Squares'', \emph{Technometrics, accepted}.
}
\author{
Yixin Wang
}
