% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{matchingScore_C}
\alias{matchingScore_C}
\alias{matchingScore_C_sparse_big}
\title{Fast C++ computation of the final posterior probabilities in the E-M Winkler's method}
\usage{
matchingScore_C(agreemat, m, u, nA, nB)

matchingScore_C_sparse_big(mat_A, mat_B, m, u)
}
\arguments{
\item{agreemat}{binary sparse matrix of dimensions \code{N x K} containing the agreement rows for each pair of potential matches.}

\item{m}{vector of length \code{K} containing the agreement weights.}

\item{u}{vector of length \code{K} containing the disagreement weights.}

\item{nA}{integer indicating the number of observations to be matched.}

\item{nB}{integer indicating the number of observations to be matched with.}

\item{mat_A}{a \code{nB x K} matrix of the observations to be matched.}

\item{mat_B}{a \code{nA x K} matrix of the database into which a match is looked for.}
}
\description{
\code{matchingScore_C_sparse_big} implements a version using sparse matrices. It has a better 
management of memory but is a little bit slower (indicated for big matrices)
}
