% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcts_used_for_ind_comp.R
\name{vertices}
\alias{vertices}
\title{Compute vertices of the Minimal Convex Hull shaping species from a single
assemblage in a multidimensional functional space}
\usage{
vertices(sp_faxes_coord, order_2D = FALSE, check_input = FALSE)
}
\arguments{
\item{sp_faxes_coord}{a matrix of species coordinates in a chosen functional
space. Species coordinates have been retrieved thanks to
\code{\link{tr.cont.fspace}} or \code{\link{quality.fspaces}}.}

\item{order_2D}{a logical value defining whether vertices names are
reordered so that they define a convex polygon in 2D which is convenient
for plotting. Default is \code{FALSE}, vertices ordered as in row names of
'sp_faxes_coord'.}

\item{check_input}{a logical value defining whether inputs are checked
before computation: species names must be put as row.names, there must be
no NA and species number must be superior to (axes number + 1). Default:
\code{check_input = TRUE}.}
}
\value{
A vector containing names of species being vertices \code{vert_nm}.
}
\description{
This function identifies species that are vertices of the minimal convex
hull enclosing a community in a multidimensional functional space. This
function is using the \code{\link[geometry]{convhulln}} function.
}
\examples{
# Load Species*Traits dataframe:
 data("fruits_traits", package = "mFD")

# Load Assemblages*Species dataframe:      
 data("baskets_fruits_weights", package = "mFD") 

# Load Traits categories dataframe:
 data("fruits_traits_cat", package = "mFD") 
 
# Compute functional distance 
 sp_dist_fruits <- mFD::funct.dist(sp_tr         = fruits_traits,
                                   tr_cat        = fruits_traits_cat,
                                   metric        = "gower",
                                   scale_euclid  = "scale_center",
                                   ordinal_var   = "classic",
                                   weight_type   = "equal",
                                   stop_if_NA    = TRUE)
  
# Compute functional spaces quality to retrieve species coordinates matrix:
 fspaces_quality_fruits <- mFD::quality.fspaces(
                                  sp_dist             = sp_dist_fruits, 
                                  maxdim_pcoa         = 10,
                                  deviation_weighting = "absolute",
                                  fdist_scaling       = FALSE,
                                  fdendro             = "average")
 
# Retrieve species coordinates matrix:
sp_faxes_coord_fruits <- fspaces_quality_fruits$details_fspaces$sp_pc_coord

# Compute vertices and order them clockwise:
 vert_nm <- vertices(sp_faxes_coord_fruits[ , c("PC1", "PC2")], 
  order_2D = TRUE, check_input = TRUE)
 vert_nm

}
\author{
Camille Magneville and Sebastien Villeger
}
