% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.bracket.R
\name{find.bracket}
\alias{find.bracket}
\title{Fill out a bracket based on some criteria}
\usage{
find.bracket(bracket.empty, prob.matrix = NULL, prob.source = c("pop",
  "Pom", "538"), pool.source = c("pop", "Pom", "538"), league = c("men",
  "women"), year = 2017, num.candidates = 100, num.sims = 1000,
  criterion = c("percentile", "score", "win"), pool.size = 30,
  bonus.round = c(1, 2, 4, 8, 16, 32), bonus.seed = rep(0, 16),
  bonus.combine = c("add", "multiply"))
}
\arguments{
\item{bracket.empty}{a length-64 character vector giving the field of 64
teams in the tournament, in order of initial overall seeding}

\item{prob.matrix}{a matrix of probabilities, with rows and columns
corresponding to teams, matching the output of bradley.terry().
This probabilities are used to simulate candidate brackets and outcomes on
which to evaluate the candidates. If NULL, prob.source is used.}

\item{prob.source}{source from which to use round probabilities to simulate
candidate brackets and outcomes --- "pop": ESPN's population of picks
(default), "Pom": Ken Pomeroy's predictions (kenpom.com), or
"538": predictions form fivethirtyeight.com.
Ignored if prob.matrix is specified.}

\item{pool.source}{source from which to use round probabilities to simulate
entries of opponents in pool. Same options as prob.source.}

\item{league}{which league: "men" (default) or "women", for pool.source.}

\item{year}{year of tournament, used for prob.source and pool.source}

\item{num.candidates}{number of random brackets to try, taking the best one
(default is 100)}

\item{num.sims}{number of simulations over which to evaluate the candidate
brackets (default is 1000)}

\item{criterion}{how to choose among candidate brackets:
"percentile" (default, maximize expected percentile within pool),
"score" (maximize expected number of points) or "win" (maximize probabilty
of winning pool).}

\item{pool.size}{number of brackets in your pool (excluding yours), matters
only if criterion == "win" (default is 30)}

\item{bonus.round}{a length-6 vector giving the number of points awarded in
your pool's scoring rules for correct picks in each round (default is
2^round)}

\item{bonus.seed}{a length-16 vector giving the bonus awarded for correctly
picking winner based on winner's seed (default is zero)}

\item{bonus.combine}{how to combine the round bonus with the seed bonus to
get the number of points awarded for each correct pick: "add" (default) or
multiply}
}
\value{
the length-63 character vector describing the filled bracket which
  performs best according to criterion among all num.candidates brackets
  tried, across num.sims simulations of a pool of pool.size with scoring
  rules specified by bonus.round, bonus.seed and bonus.combine
}
\description{
Fill out a bracket based on some criteria
}
\examples{
find.bracket(bracket.empty = bracket.men.2017, prob.source = "538",
  pool.source = "pop", league = "men", year = 2017)
}
\author{
sspowers
}
