% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-args-custom-search.R
\name{check_args_custom_search}
\alias{check_args_custom_search}
\title{Custom Search Arguments Check}
\usage{
check_args_custom_search(imapconf, custom_search, negate, by, esearch,
  return_imapconf, retries)
}
\arguments{
\item{imapconf}{An object of class \code{imapconf} generated with
\link{configure_imap} and with a \code{mbox} item added after a
mailbox selection with \link{select_mailbox}.}

\item{negate}{If \code{TRUE}, negates the search and seeks for
"NOT search_criterion". Default is \code{FALSE}.}

\item{by}{Which id (\code{MSN} or \code{UID}) to use when searching for
messages. \code{"MSN"} or message squence number is a message's relative
position to the older message in the mailbox. It may change after deleting
or moving messages. For instance, if a message is deleted, message sequence
numbers are reordered to fill the gap. \code{"UID"} or unique identifier
is always the same during the life cycle of a message. Default is
\code{"MSN"}.}

\item{esearch}{A logical. Default is \code{FALSE}. If the IMAP server has
\code{ESEARCH} capability, it can be used to optimize search results. It
allows to condense results to message sets to cut down on transmission
costs, e.g. \code{1:5} instead of writing ids individually such as
code{1,2,3,4,5}. It can be used along with buffersize to avoid results
stripping. Check if your IMAP server supports \code{SEARCH} with
\code{\link{list_server_capabilities}}.}

\item{return_imapconf}{A logical. If \code{TRUE}, the function returns a
\code{list} of length \code{2}, containing the \code{imapconf} object
(IMAP settings) and the search results as message ids (\code{"MSN"} or
\code{"UID"}). If \code{FALSE}, returns only the message ids as a numeric
vector. Default is \code{TRUE}.}

\item{retries}{Number of attempts to connect and execute the command. Default
is \code{2}.}

\item{custom_request}{A string directly specifying what to search or
constructed by a combination of operators helper functions \link{OR} and
\link{AND}, and criteria helper functions such as \link{before}, \link{since},
\link{on}, \link{sent_before}, \link{sent_since}, \link{sent_on},
\link{flag}, \link{string}, \link{smaller_than}, \link{larger_than},
\link{younger_than}, or \link{younger_than}.}
}
\value{
\code{NULL} if arguments are correct.
}
\description{
Internal helper function for checking arguments used in search
    functions.
}
\seealso{
Other search helper: \code{\link{check_args_search_date}},
  \code{\link{check_args_search_flag}},
  \code{\link{check_args_search_period}},
  \code{\link{check_args_search_size}},
  \code{\link{check_args_search_string}},
  \code{\link{check_args_search_within}},
  \code{\link{define_searchrequest_custom}},
  \code{\link{define_searchrequest_date}},
  \code{\link{define_searchrequest_flag}},
  \code{\link{define_searchrequest_period}},
  \code{\link{define_searchrequest_size}},
  \code{\link{define_searchrequest_string}},
  \code{\link{define_searchrequest_within}},
  \code{\link{fix_search_stripping}}

Other check args: \code{\link{check_args_add_replace_flags}},
  \code{\link{check_args_copy_msg}},
  \code{\link{check_args_delete_msg}},
  \code{\link{check_args_expunge}},
  \code{\link{check_args_fetch_full_msg}},
  \code{\link{check_args_fetch_msg_header}},
  \code{\link{check_args_fetch_msg_metadata}},
  \code{\link{check_args_fetch_msg_text}},
  \code{\link{check_args_get_max_min_id}},
  \code{\link{check_args_move_msg}},
  \code{\link{check_args_remove_flags}},
  \code{\link{check_args_search_date}},
  \code{\link{check_args_search_flag}},
  \code{\link{check_args_search_period}},
  \code{\link{check_args_search_size}},
  \code{\link{check_args_search_string}},
  \code{\link{check_args_search_within}}
}
\concept{check args}
\concept{search helper}
\keyword{internal}
