% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egen.R
\name{egen}
\alias{egen}
\title{An extension to \code{generate}}
\usage{
egen(data, var, cut = NULL, new_var = NULL, lbl = NULL)
}
\arguments{
\item{data}{Dataset}

\item{var}{Exisitng variable}

\item{cut}{either a single number or a numeric vector.}

\item{new_var}{name of new variable to be generated}

\item{lbl}{labels to specify}
}
\description{
\code{egen()} transforms a numeric vector to a factor vector.
}
\details{
\code{egen} allows easy conversion of a numerical variable to a categorical
variable.

\strong{Cut-off Intervals}

If the interval is not specified, it is cut at an interval of 10,
starting from the minimum value. Otherwise,
it is divided into corresponding intervals by specified cut-off points.

\strong{Automatic Labelling}

If \code{lbl} is not specified, labels are constructed in
this format: \code{lbl[##-##]}
}
\examples{

## use infert data

data(infert)
codebook(infert)
summ(infert, age)


## transform continuous to category
infert.new <- egen(infert, age, c(20, 30, 40, 50))
tab(infert.new, age.cat)

## specifiy labels and name
infert.new <- egen(infert, age, c(20, 30, 40), "age_cat", c("<30", "30-39", "40+"))
tab(infert.new, age_cat)


}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
