% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabRates.R
\name{strate}
\alias{strate}
\title{Tabulate Incidence Rates from time-to-event data}
\usage{
strate(data, time, status, ..., fail = NULL, per = 1, plot = TRUE, rnd = 3)
}
\arguments{
\item{data}{Dataset}

\item{time}{person-time variable}

\item{status}{outcome variable: preferrably 1 for event, 0 for censored}

\item{...}{Variable or multiple variables
Colon separator \code{:} can be used to specify multiple variables.}

\item{fail}{Specify failure event}

\item{per}{units to be used in reported rates}

\item{plot}{logical value to display plots of rates across a categorical
variable}

\item{rnd}{Rounding of numbers}
}
\description{
\code{strate()} calculates incidence rates and Corresponding 95\\% CI.
}
\details{
Rates of event occurrences, known as incidence rates are outcome measures in
longitudinal studies. In most longitudinal studies, follow-up times vary due
to logistic resasons, different periods of recruitment, delay enrolment into
the study, lost-to-follow-up, immigration or emigration and death.

\strong{Follow-up time in longitudinal studies}

Period of observation (called as follow-up time) starts when individuals join
the study and ends when they either have an outcome of interest, are lost-to-
follow-up or the follow-up period ends, whichever happens first. This period is
called \strong{person-year-at-risk}. This is denoted by \emph{PY} in \code{strate}
function's output and numer of event by \emph{D}.

\strong{Rate}

is calcluated using the following formula:
\deqn{\lambda = D / PY}

\strong{Confidence interval of rate}

is derived using the following formula:

\deqn{95\% CI (rate) = rate x Error Factor}
\deqn{Error Factor (rate) = exp(1.96 / \sqrt{D})}

\code{plot}, if \code{TRUE}, produces a graph of the rates against
the numerical code used for categories of \code{by}.
}
\references{
Betty R. Kirkwood, Jonathan A.C. Sterne (2006, ISBN:978–0–86542–871–3)
}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
