% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_functions.R
\name{simTheta}
\alias{simTheta}
\title{Simulate theta values}
\usage{
simTheta(N, mean_v, sd_v, cor_v)
}
\arguments{
\item{N}{the number of examinees.}

\item{mean_v}{a vector containing the mean of each dimension.}

\item{sd_v}{a vector containing the standard deviation of each dimension.}

\item{cor_v}{a correlation matrix.}
}
\value{
a theta matrix.
}
\description{
\code{\link{simTheta}} is a function for generating a theta matrix based on the given
sample size, mean, standard deviation, and correlation matrix.
}
\details{
\code{\link{simTheta}} calls \code{\link{mvrnorm}} internally.
}
\examples{
o <- simTheta(
  N      = 100,
  mean_v = c(0, 0, 0),
  sd_v   = c(1, 1, 1),
  cor_v  = diag(1, 3)
)

}
