% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_syntenic_genes.R
\name{get_syntenic_genes}
\alias{get_syntenic_genes}
\title{get the syntenic genes as a table}
\usage{
get_syntenic_genes(orthologs_df)
}
\arguments{
\item{orthologs_df}{dataframe. orthologs with genomic coordinates loaded by load_orthologs()}
}
\value{
dataframe composed of details for each detected syntenic block of genes. It contains the following columns : sp1.Chr, sp1.Start, sp1.End, sp2.Chr, sp2.Start, sp2.End, size, sp1.IDs, sp2.IDs
}
\description{
This is a function to extract all the syntenic genes from an orthologs_df. It requires as input an orthologs_df loaded by load_orthologs().
}
\examples{
# basic usage of get_syntenic_genes :

orthologs_file <- system.file("extdata","Bflo_vs_Pech.tab",package="macrosyntR")
bedfile_sp1 <- system.file("extdata","Bflo.protein_products.bed",package="macrosyntR")
bedfile_sp2 <- system.file("extdata","Pech.protein_products.bed",package="macrosyntR")

my_orthologs <- load_orthologs(orthologs_table = orthologs_file,
                               sp1_bed = bedfile_sp1,
                               sp2_bed = bedfile_sp2)
                               
my_syntenic_block_of_genes <- get_syntenic_genes(my_orthologs)

}
\seealso{
\code{\link[=load_orthologs]{load_orthologs()}}
}
