% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ops.r
\name{arithops}
\alias{arithops}
\alias{+,madness,missing-method}
\alias{+,madness-class}
\alias{-,madness,missing-method}
\alias{-,madness-class}
\alias{+,madness,madness-method}
\alias{+,madness,madness-class}
\alias{+,madness,numeric-method}
\alias{+,madness,numeric-class}
\alias{+,madness,array-method}
\alias{+,madness,array-class}
\alias{+,numeric,madness-method}
\alias{+,numeric,madness-class}
\alias{+,array,madness-method}
\alias{+,array,madness-class}
\alias{-,madness,madness-method}
\alias{-,madness,madness-class}
\alias{-,madness,numeric-method}
\alias{-,madness,numeric-class}
\alias{-,madness,array-method}
\alias{-,madness,array-class}
\alias{-,numeric,madness-method}
\alias{-,numeric,madness-class}
\alias{-,array,madness-method}
\alias{-,array,madness-class}
\alias{*,madness,madness-method}
\alias{*,madness,madness-class}
\alias{*,madness,numeric-method}
\alias{*,madness,numeric-class}
\alias{*,madness,array-method}
\alias{*,madness,array-class}
\alias{*,numeric,madness-method}
\alias{*,numeric,madness-class}
\alias{*,array,madness-method}
\alias{*,array,madness-class}
\alias{/,madness,madness-method}
\alias{/,madness,madness-class}
\alias{/,madness,numeric-method}
\alias{/,madness,numeric-class}
\alias{/,madness,array-method}
\alias{/,madness,array-class}
\alias{/,numeric,madness-method}
\alias{/,numeric,madness-class}
\alias{/,array,madness-method}
\alias{/,array,madness-class}
\alias{^,madness,madness-method}
\alias{^,madness,madness-class}
\alias{^,madness,numeric-method}
\alias{^,madness,numeric-class}
\alias{^,madness,array-method}
\alias{^,madness,array-class}
\alias{^,numeric,madness-method}
\alias{^,numeric,madness-class}
\alias{^,array,madness-method}
\alias{^,array,madness-class}
\title{Basic Arithmetic Operations.}
\usage{
\S4method{+}{madness,missing}(e1, e2)

\S4method{-}{madness,missing}(e1, e2)

\S4method{+}{madness,madness}(e1, e2)

\S4method{+}{madness,numeric}(e1, e2)

\S4method{+}{madness,array}(e1, e2)

\S4method{+}{numeric,madness}(e1, e2)

\S4method{+}{array,madness}(e1, e2)

\S4method{-}{madness,madness}(e1, e2)

\S4method{-}{madness,numeric}(e1, e2)

\S4method{-}{madness,array}(e1, e2)

\S4method{-}{numeric,madness}(e1, e2)

\S4method{-}{array,madness}(e1, e2)

\S4method{*}{madness,madness}(e1, e2)

\S4method{*}{madness,numeric}(e1, e2)

\S4method{*}{madness,array}(e1, e2)

\S4method{*}{numeric,madness}(e1, e2)

\S4method{*}{array,madness}(e1, e2)

\S4method{/}{madness,madness}(e1, e2)

\S4method{/}{madness,numeric}(e1, e2)

\S4method{/}{madness,array}(e1, e2)

\S4method{/}{numeric,madness}(e1, e2)

\S4method{/}{array,madness}(e1, e2)

\S4method{^}{madness,madness}(e1, e2)

\S4method{^}{madness,numeric}(e1, e2)

\S4method{^}{madness,array}(e1, e2)

\S4method{^}{numeric,madness}(e1, e2)

\S4method{^}{array,madness}(e1, e2)
}
\arguments{
\item{e1, e2}{\code{madness} or numeric values}
}
\description{
These perform basic arithmetic operations on \code{madness} objects: unary
plus and minus, addition, subtraction, multiplication, division and power.
}
\examples{
set.seed(123)
y <- array(rnorm(3*3),dim=c(3,3))
dy <- matrix(rnorm(length(y)*2),ncol=2)
dx <- crossprod(matrix(rnorm(ncol(dy)*100),nrow=100))
obj0 <- madness(val=y,vtag='y',xtag='x',dvdx=dy,varx=dx)
z <- array(rnorm(3*3),dim=c(3,3))

anobj <- + obj0
anobj <- - obj0
anobj <- 6 - obj0
anobj <- 1 + obj0
anobj <- obj0 - 3
anobj <- z + obj0 
anobj <- obj0 - z

obj1 <- obj0 ^ 2
anobj <- (0.3 * obj0) + (5.1 * obj1)

anobj <- 2 ^ obj0
anobj <- obj1 ^ obj0
anobj <- obj1 / obj0
anobj <- z / obj0

}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
