% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/madr.enumerate.r
\name{madr.enumerate}
\alias{madr.enumerate}
\title{Model averaged double robust estimate with enumeration of all possible models (linear terms only)}
\usage{
madr.enumerate(Y, X, U, W = NULL, tau = 1, two.stage = F)
}
\arguments{
\item{Y}{vector of the outcome}

\item{X}{vector of the treatment indicator (0/1)}

\item{U}{matrix of covariates to be considered for inclusion/exclusion}

\item{W}{matrix of covariates that will be included in all models (optional)}

\item{tau}{scalar value for the prior model dependence (1 is an independent prior)}

\item{two.stage}{indicator if the two-stage procedure for calculating the model weights should be used}
}
\value{
A object of class madr.enumerate. The object contains the following named components:
\item{out}{a matrix that contains the BIC and estimated treatment from each outcome model}
\item{ps}{a matrix that contains the BIC from each propensity score model}
\item{dr}{a matrix that contains the model-specific double robust estimates}
\item{U.names}{the column names of U}
}
\description{
This function enumerates all possible models and estimates a model averaged double robust estimate
}

