% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-catalogue_functions.R
\name{as_taxonomy}
\alias{as_taxonomy}
\title{Validate and coerce any object as a taxonomy}
\usage{
as_taxonomy(object)
}
\arguments{
\item{object}{A potential taxonomy to be coerced.}
}
\value{
A list of data frame(s) with \code{madshapR::class} 'taxonomy'.
}
\description{
Confirms that the input object is a valid taxonomy and returns it as a
taxonomy with the appropriate \code{madshapR::class} attribute. This function
mainly helps validate input within other functions of the package but could
be used to check if a taxonomy is valid.
}
\details{
A taxonomy is a classification schema that can be defined for variable
attributes. A taxonomy is usually extracted from an
\href{https://www.obiba.org/pages/products/opal/}{Opal environment}, and a
taxonomy object is a data frame that must contain at least the columns
\code{taxonomy}, \code{vocabulary}, and \code{terms}. Additional details about Opal
taxonomies are
\href{https://opaldoc.obiba.org/en/latest/web-user-guide/administration/taxonomies.html}{available online}.
}
\examples{
{

# use madshapR_DEMO provided by the package

###### Example
as_taxonomy(madshapR_DEMO$taxonomy_PARIS)

}

}
\seealso{
\href{https://opaldoc.obiba.org/en/dev/magma-user-guide/value/type.html}{Opal documentation}
}
