% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-dictionaries_functions.R
\name{data_dict_list_nest}
\alias{data_dict_list_nest}
\title{Bind listed data dictionaries}
\usage{
data_dict_list_nest(data_dict_list, name_group = NULL)
}
\arguments{
\item{data_dict_list}{A list of data frame(s) representing metadata to be
transformed.}

\item{name_group}{A character string of one column in the dataset that can be
taken as a grouping column.}
}
\value{
A list of data frame(s) identifying a workable data dictionary structure.
}
\description{
Binds a list of data dictionaries into one data dictionary.
This is a wrapper function analogous to \code{\link[dplyr:bind_rows]{dplyr::bind_rows()}}.
}
\details{
A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.
}
\examples{
{

# use madshapR_DEMO provided by the package
library(dplyr)

# Create a list of data dictionaries where the column 'table' is added to 
# refer to the associated dataset. The object created is not a 
# data dictionary per say, but can be used as a structure which can be 
# shaped into a data dictionary.

data_dict_list <- list(
  data_dict_1 <- madshapR_DEMO$data_dict_TOKYO ,
  data_dict_2 <- madshapR_DEMO$data_dict_MELBOURNE)
names(data_dict_list) = c("dataset_TOKYO","dataset_MELBOURNE")

glimpse(data_dict_list_nest(data_dict_list, name_group = 'table'))

}

}
\seealso{
\code{\link[dplyr:bind_rows]{dplyr::bind_rows()}}
}
