% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-dictionaries_functions.R
\name{data_dict_match_dataset}
\alias{data_dict_match_dataset}
\title{Inner join between a dataset and its associated data dictionary}
\usage{
data_dict_match_dataset(
  dataset,
  data_dict,
  data_dict_apply = FALSE,
  output = c("dataset", "data_dict")
)
}
\arguments{
\item{dataset}{A dataset object.}

\item{data_dict}{A list of data frame(s) representing metadata of the input
dataset.}

\item{data_dict_apply}{Whether data dictionary(ies) should be applied to
associated dataset(s), creating labelled dataset(s) with variable attributes.
Any previous attributes will be preserved. FALSE by default.}

\item{output}{A vector of character string which indicates if the function
returns a dataset ('dataset'), data dictionary ('data_dict') of both.
Default is c('dataset','data_dict').}
}
\value{
Either a data frame, identifying the dataset, or a list of data frame(s)
identifying a data dictionary. Returns both in a list by default.
}
\description{
Performs an inner join between a dataset and its associated data dictionary,
keeping only variables present in both. This function returns the matched
dataset rows, the matched data dictionary rows, or both, in a list.
}
\details{
A dataset is a data table containing variables. A dataset object is a
data frame and can be associated with a data dictionary. If no
data dictionary is provided with a dataset, a minimum workable
data dictionary will be generated as needed within relevant functions.
Identifier variable(s) for indexing can be specified by the user.
The id values must be non-missing and will be used in functions that
require it. If no identifier variable is specified, indexing is
handled automatically by the function.

A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.
}
\examples{
{

# use madshapR_DEMO provided by the package
library(dplyr)

dataset <- madshapR_DEMO$dataset_MELBOURNE \%>\% select(-1)
data_dict <- madshapR_DEMO$data_dict_MELBOURNE
head(data_dict_match_dataset(dataset, data_dict, out = 'dataset'))
glimpse(data_dict_match_dataset(dataset, data_dict, out = 'data_dict'))

}

}
