% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-dataset_functions.R
\name{dossier_create}
\alias{dossier_create}
\title{Generate a dossier from a list of one or more datasets}
\usage{
dossier_create(dataset_list, data_dict_apply = FALSE)
}
\arguments{
\item{dataset_list}{A list of data frame, each of them being dataset object.}

\item{data_dict_apply}{Whether data dictionary(ies) should be applied to
associated dataset(s), creating labelled dataset(s) with variable attributes.
Any previous attributes will be preserved. FALSE by default.}
}
\value{
A list of data frame(s), containing input dataset(s).
}
\description{
Generates a dossier object (list of one or more datasets).
}
\details{
A dataset is a data table containing variables. A dataset object is a
data frame and can be associated with a data dictionary. If no
data dictionary is provided with a dataset, a minimum workable
data dictionary will be generated as needed within relevant functions.
Identifier variable(s) for indexing can be specified by the user.
The id values must be non-missing and will be used in functions that
require it. If no identifier variable is specified, indexing is
handled automatically by the function.
}
\examples{
{

# use madshapR_DEMO provided by the package
library(dplyr)

###### Example 1: datasets can be gathered into a dossier which is a list.
dossier <- dossier_create(
 dataset_list = list(
   dataset_MELBOURNE = madshapR_DEMO$dataset_MELBOURNE,
   dataset_PARIS = madshapR_DEMO$dataset_PARIS ))

glimpse(dossier)
    
###### Example 2: Any data frame can be gathered into a dossier
glimpse(dossier_create(list(iris, mtcars)))
   
}

}
