% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-catalogue_functions.R
\name{valueType_adjust}
\alias{valueType_adjust}
\title{Attribute the valueType from a data dictionary to a dataset, or vice versa}
\usage{
valueType_adjust(from, to = NULL)
}
\arguments{
\item{from}{Object to be adjusted. Can be either a dataset or a data
dictionary.}

\item{to}{Object to be adjusted. Can be either a dataset or a data
dictionary. NULL by default.}
}
\value{
Either a data frame, identifying the dataset, or a list of data frame(s)
identifying a data dictionary, depending which is 'to'.
}
\description{
Takes the valueType of the input (from) and attributes it to the output (to).
The parameters 'from' and 'to' can be either a dataset or a data dictionary.
Depending on the input provided, the valueType replaced is either in the
'valueType' column of a data dictionary or cast to a column in a dataset.
If 'to' is not provided, the function calls \code{\link[=valueType_self_adjust]{valueType_self_adjust()}}
instead. The possible values returned are 'date', 'boolean', 'integer',
'decimal', and text'.
}
\details{
A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.

A dataset is a data table containing variables. A dataset object is a
data frame and can be associated with a data dictionary. If no
data dictionary is provided with a dataset, a minimum workable
data dictionary will be generated as needed within relevant functions.
Identifier variable(s) for indexing can be specified by the user.
The id values must be non-missing and will be used in functions that
require it. If no identifier variable is specified, indexing is
handled automatically by the function.

The valueType is a declared property of a variable that is required in
certain functions to determine handling of the variables. Specifically,
valueType refers to the
\href{https://opaldoc.obiba.org/en/dev/variables-data.html#value-types}{OBiBa data type of a variable}.
The valueType is specified in a data dictionary in a column 'valueType' and
can be associated with variables as attributes. Acceptable valueTypes
include 'text', 'integer', 'decimal', 'boolean', datetime', 'date'. The full
list of OBiBa valueType possibilities and their correspondence with R data
types are available using \link{valueType_list}. The valueType can be used to
coerce the variable to the corresponding data type.
}
\examples{
{

# use madshapR_DEMO provided by the package
library(dplyr)

dataset <- madshapR_DEMO$dataset_TOKYO[c(1:4),'prg_ever']
data_dict <-
  madshapR_DEMO$data_dict_TOKYO \%>\%
  data_dict_filter(filter_var = 'name == "prg_ever"') \%>\%
  as_data_dict_mlstr()

head(valueType_adjust(from = data_dict,to = dataset))

}

}
\seealso{
\code{\link[=valueType_self_adjust]{valueType_self_adjust()}}
}
