\name{component.animation}
\Rdversion{1.1}
\alias{component.animation}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Plot An Animation for A Specific Component of All the Micro-spins
}
\description{
  This function utilizes animation package to plot an animation for the
  time evolution of a specific component of all the micro-spins. This is
  the most direct way to view the system and is very helpful to study
  the system.
}
\usage{
component.animation(g = NA, by = 10, component = 2, time = NA)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{g}{
    an evolution object generated by \code{\link{multispin.evol}}. This
      arfument must be given. All the information about the time
      evolution is contained in \code{g$process}.
}
  \item{by}{
    show the system configuration every \code{by} elements in the list
    \code{g$time} (see \code{\link{multispin.evol}} for more
    explanations).
}
  \item{component}{
    which component of the spins are plotted. \eqn{1,2,3} corresponds to
    \eqn{x,y,z} 
}
  \item{time}{
    the maximum time steps that the animation will run to. If it is not
    given, the animation will run to the maximum of \code{g$time}.
}
}
\details{
  This function utilizes animation package to plot an animation for the
  time evolution of a specific component of all the micro-spins. If
  the package animation is not loaded yet, it will load it automatically.

  All the micro-magnets are
  plotted on a straight no matter what the system's real geometric
  configuration is (The real geometric configuration is described by
  \code{positions} or \code{coupling.matrix} in the function
  \code{\link{multispin.evol}}). The order of the micro-magnets are
  decided by the way how the spins are numbered. 
}
\references{
  For an introduction to the R package animation, please take a look at
  \url{http://cran.r-project.org/web/packages/animation/index.html}
  \url{http://animation.yihui.name}
  \url{https://github.com/yihui/animation}
}
\author{
  Hai Qian, Electrical Engineering Department, UCLA
}
\seealso{
  \code{\link{multispin.evol}} to generate simulation result (evolution
  object) and check out the examples there
}


