% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{centered_ipd_sat}
\alias{centered_ipd_sat}
\title{Centered patient data from single arm trial}
\format{
A data frame with 500 rows and 14 columns:
\describe{
\item{USUBJID}{Unique subject identifiers for patients.}
\item{ARM}{Assigned treatment arm.}
\item{AGE}{Age in years at baseline.}
\item{SEX}{Sex of patient recorded as character \code{"Male"}/\code{"Female"}.}
\item{SMOKE}{Smoking status at baseline as integer \code{1}/\code{0}.}
\item{ECOG0}{Indicator of ECOG score = 0 at baseline as integer \code{1}/\code{0}.}
\item{N_PR_THER}{Number of prior therapies received as integer \verb{1, 2, 3, 4}.}
\item{SEX_MALE}{Indicator of \code{SEX == "Male"} as numeric \code{1}/\code{0}.}
\item{AGE_CENTERED}{Age in years at baseline relative to average in aggregate data \link{agd}.}
\item{AGE_MEDIAN_CENTERED}{\code{AGE} greater/less than \code{MEDIAN_AGE} in \link{agd} coded as \code{1}/\code{0} and then centered at
0.5.}
\item{AGE_SQUARED_CENTERED}{\code{AGE} squared and centered with respect to the \code{AGE} in \link{agd}. The squared age in the
aggregate data is derived from the \eqn{E(X^2)} term in the variance formula.}
\item{SEX_MALE_CENTERED}{\code{SEX_MALE} centered by the proportion of male patients in \link{agd}}
\item{ECOG0_CENTERED}{\code{ECOG0} centered by the proportion of \code{ECOG0} in \link{agd}}
\item{SMOKE_CENTERED}{\code{SMOKE} centered by the proportion of \code{SMOKE} in \link{agd}}
\item{N_PR_THER_MEDIAN_CENTERED}{\code{N_PR_THER} centered by the median in \link{agd}.}
}
}
\usage{
centered_ipd_sat
}
\description{
Centered patient data from single arm trial
}
\seealso{
Other unanchored datasets: 
\code{\link{adrs_sat}},
\code{\link{adsl_sat}},
\code{\link{adtte_sat}},
\code{\link{agd}},
\code{\link{pseudo_ipd_sat}},
\code{\link{weighted_sat}}
}
\concept{unanchored datasets}
\keyword{dataset}
