% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Segment.R
\name{SegmentSource}
\alias{SegmentSource}
\title{Segment}
\description{
A Segment object is automatically constructed and attached to
the Pipeline when a call to \verb{make_*()} is made. It stores the relationships
between targets, dependencies, and sources.
}
\seealso{
Other segment: 
\code{\link{SegmentRecipe}},
\code{\link{Segment}}
}
\concept{segment}
\keyword{internal}
\section{Super class}{
\code{\link[makepipe:Segment]{makepipe::Segment}} -> \code{SegmentSource}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{source}}{The path to an R script which makes the \code{targets}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SegmentSource-new}{\code{SegmentSource$new()}}
\item \href{#method-SegmentSource-update_result}{\code{SegmentSource$update_result()}}
\item \href{#method-SegmentSource-execute}{\code{SegmentSource$execute()}}
\item \href{#method-SegmentSource-clone}{\code{SegmentSource$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="makepipe" data-topic="Segment" data-id="annotate"><a href='../../makepipe/html/Segment.html#method-Segment-annotate'><code>makepipe::Segment$annotate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="makepipe" data-topic="Segment" data-id="print"><a href='../../makepipe/html/Segment.html#method-Segment-print'><code>makepipe::Segment$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SegmentSource-new"></a>}}
\if{latex}{\out{\hypertarget{method-SegmentSource-new}{}}}
\subsection{Method \code{new()}}{
Initialise a new Segment
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SegmentSource$new(
  id,
  source,
  targets,
  dependencies,
  packages,
  envir,
  force,
  executed,
  result,
  execution_time
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{An integer that uniquely identifies the segment}

\item{\code{source}}{The path to an R script which makes the \code{targets}}

\item{\code{targets}}{A character vector of paths to files}

\item{\code{dependencies}}{A character vector of paths to files which the \code{targets}
depend on}

\item{\code{packages}}{A character vector of names of packages which \code{targets}
depend on}

\item{\code{envir}}{The environment in which to execute the instructions.}

\item{\code{force}}{A logical determining whether or not execution of the \code{source}
or \code{recipe} will be forced (i.e. happen whether or not the targets are
out-of-date)}

\item{\code{executed}}{A logical, whether or not the instructions were executed}

\item{\code{result}}{An object, whatever is returned by executing the instructions}

\item{\code{execution_time}}{A difftime, the time taken to execute the instructions}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SegmentSource-update_result"></a>}}
\if{latex}{\out{\hypertarget{method-SegmentSource-update_result}{}}}
\subsection{Method \code{update_result()}}{
Update the Segment with new execution information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SegmentSource$update_result(executed, execution_time, result)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{executed}}{A logical, whether or not the instructions were executed}

\item{\code{execution_time}}{A difftime, the time taken to execute the instructions}

\item{\code{result}}{An object, whatever is returned by executing the instructions}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SegmentSource-execute"></a>}}
\if{latex}{\out{\hypertarget{method-SegmentSource-execute}{}}}
\subsection{Method \code{execute()}}{
Execute the Segment
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SegmentSource$execute(envir = NULL, quiet = getOption("makepipe.quiet"), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{envir}}{The environment in which to execute the instructions.}

\item{\code{quiet}}{A logical determining whether or not messages are signaled}

\item{\code{...}}{Additional parameters to pass to \code{base::source()}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SegmentSource-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SegmentSource-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SegmentSource$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
