% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm-verify.R
\name{llm_verify}
\alias{llm_verify}
\alias{llm_vec_verify}
\title{Verify if a statement about the text is true or not}
\usage{
llm_verify(
  .data,
  col,
  what,
  yes_no = factor(c(1, 0)),
  pred_name = ".verify",
  additional_prompt = ""
)

llm_vec_verify(
  x,
  what,
  yes_no = factor(c(1, 0)),
  additional_prompt = "",
  preview = FALSE
)
}
\arguments{
\item{.data}{A \code{data.frame} or \code{tbl} object that contains the text to be
analyzed}

\item{col}{The name of the field to analyze, supports \code{tidy-eval}}

\item{what}{The statement or question that needs to be verified against the
provided text}

\item{yes_no}{A size 2 vector that specifies the expected output. It is
positional. The first item is expected to be value to return if the
statement about the provided text is true, and the second if it is not. Defaults
to: \code{factor(c(1, 0))}}

\item{pred_name}{A character vector with the name of the new column where the
prediction will be placed}

\item{additional_prompt}{Inserts this text into the prompt sent to the LLM}

\item{x}{A vector that contains the text to be analyzed}

\item{preview}{It returns the R call that would have been used to run the
prediction. It only returns the first record in \code{x}. Defaults to \code{FALSE}
Applies to vector function only.}
}
\value{
\code{llm_verify} returns a \code{data.frame} or \code{tbl} object.
\code{llm_vec_verify} returns a vector that is the same length as \code{x}.
}
\description{
Use a Large Language Model (LLM) to see if something is true or not
based the provided text
}
\examples{
\donttest{
library(mall)

data("reviews")

llm_use("ollama", "llama3.2", seed = 100, .silent = TRUE)

# By default it will return 1 for 'true', and 0 for 'false',
# the new column will be a factor type
llm_verify(reviews, review, "is the customer happy")

# The yes_no argument can be modified to return a different response
# than 1 or 0. First position will be 'true' and second, 'false'
llm_verify(reviews, review, "is the customer happy", c("y", "n"))

# Number can also be used, this would be in the case that you wish to match
# the output values of existing predictions
llm_verify(reviews, review, "is the customer happy", c(2, 1))
}

}
