% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manifesto.R
\name{mp_corpus}
\alias{mp_corpus}
\title{Get documents from the Manifesto Corpus Database}
\usage{
mp_corpus(ids, apikey = NULL, cache = TRUE, codefilter = NULL,
  codefilter_layer = "cmp_code")
}
\arguments{
\item{ids}{Information on which documents to get. This can either be a
    list of partys (as ids) and dates of elections as given to
    \code{\link{mp_metadata}} or a \code{ManifestoMetadata} object
    (\code{data.frame}) as returned by \code{\link{mp_metadata}}.
Alternatively, ids can be a logical expression specifying a subset of
the Manifesto Project's main dataset. It will be evaluated within the
data.frame returned by \code{\link{mp_maindataset}} such that all its
variables and functions thereof can be used in the expression.}

\item{apikey}{API key to use. Defaults to \code{NULL}, resulting in using
the API key set via \code{\link{mp_setapikey}}.}

\item{cache}{Boolean flag indicating whether to use locally cached data if
available.}

\item{codefilter}{A vector of CMP codes to filter the documents: only quasi-sentences
with the codes specified in \code{codefilter} are returned. If \code{NULL},
no filtering is applied}

\item{codefilter_layer}{layer to which the codefilter should apply, defaults to cmp_code}
}
\value{
an object of \code{\link[tm]{Corpus}}'s subclass
\code{\link{ManifestoCorpus}} holding the available of the requested documents
}
\description{
Documents are downloaded from the Manifesto Project Corpus Database. If 
CMP coding annotations are available, they are attached to the documents,
otherwise raw texts are provided. The documents are cached in the working
memory to ensure internal consistency, enable offline use and
reduce online traffic.
}
\details{
See \code{\link{mp_save_cache}} for ensuring reproducibility by
saving cache and version identifier to the hard drive.
See \code{\link{mp_update_cache}} for updating the locally saved content with
the most recent version from the Manifesto Project Database API.
}
\examples{
\dontrun{
corpus <- mp_corpus(party == 61620 & rile > 10)

wanted <- data.frame(party=c(41320, 41320), date=c(200909, 201309))
mp_corpus(wanted)

mp_corpus(subset(mp_maindataset(), countryname == "France"))

partially_available <- data.frame(party=c(41320, 41320), date=c(200909, 200509))
mp_corpus(partially_available)
}
}

