% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_model_predictions.R
\name{add_model_predictions}
\alias{add_model_predictions}
\title{Add predictions to the data set.
A dplyr compatible way to add predictions to a data set.}
\usage{
add_model_predictions(model = NULL, old_data = NULL, new_data = NULL)
}
\arguments{
\item{model}{A model object from `fit_model`}

\item{old_data}{The data set to which predicted values will be added.}

\item{new_data}{The data set to use for predicting.}
}
\value{
A data.frame object with a new column for predicted values
}
\description{
Add predictions to the data set.
A dplyr compatible way to add predictions to a data set.
}
\examples{
iris1 <- iris[1:50,]
iris2 <- iris[51:100,]
lm_model <- fit_model(iris1,"Sepal.Length","Sepal.Width","lm") 
head(add_model_predictions(lm_model,iris1,iris2))
}
\seealso{
\code{\link{fit_model}} \code{\link{extract_model_info}}
}
