% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_ties.R
\name{add_ties}
\alias{add_ties}
\alias{delete_ties}
\alias{add_tie_attribute}
\alias{mutate_ties}
\alias{rename_ties}
\alias{arrange_ties}
\alias{bind_ties}
\alias{join_ties}
\alias{filter_ties}
\alias{select_ties}
\alias{summarise_ties}
\title{Modifying tie data}
\usage{
add_ties(.data, ties, attribute = NULL)

delete_ties(.data, ties)

add_tie_attribute(.data, attr_name, vector)

mutate_ties(.data, ...)

rename_ties(.data, ...)

arrange_ties(.data, ...)

bind_ties(.data, ...)

join_ties(.data, object2, attr_name)

filter_ties(.data, ...)

select_ties(.data, ...)

summarise_ties(.data, ...)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{ties}{The number of ties to be added or an even list of ties.}

\item{attribute}{A named list to be added as tie or node attributes.}

\item{attr_name}{Name of the new attribute in the resulting object.}

\item{vector}{A vector of values for the new attribute.}

\item{...}{Additional arguments.}

\item{object2}{A second object to copy nodes or ties from.}
}
\value{
A tidygraph (\code{tbl_graph}) data object.
}
\description{
These functions allow users to add and delete ties and their attributes:
\itemize{
\item \code{add_ties()} adds additional ties to network data
\item \code{delete_ties()} deletes ties from network data
\item \code{add_tie_attribute()} and \code{mutate_ties()} offer ways to add
a vector of values to a network as a tie attribute.
\item \code{rename_ties()} renames tie attributes.
\item \code{bind_ties()} appends the tie data from two networks and
\code{join_ties()} merges ties from two networks,
adding a tie attribute identifying the newly added ties.
\item \code{filter_ties()} subsets ties based on some tie attribute-related logical statement.
}

Note that while \verb{add_*()}/\verb{delete_*()} functions operate similarly as comparable \code{{igraph}} functions,
\verb{mutate*()}, \verb{bind*()}, etc work like \code{{tidyverse}} or \code{{dplyr}}-style functions.
}
\examples{
  other <- create_filled(4) \%>\% mutate(name = c("A", "B", "C", "D"))
  mutate_ties(other, form = 1:6) \%>\% filter_ties(form < 4)
  add_tie_attribute(other, "weight", c(1, 2, 2, 2, 1, 2))
}
\seealso{
Other modifications: 
\code{\link{add_nodes}()},
\code{\link{as}()},
\code{\link{correlation}},
\code{\link{from}},
\code{\link{miss}},
\code{\link{reformat}},
\code{\link{split}()},
\code{\link{to_levels}},
\code{\link{to_paths}},
\code{\link{to_project}},
\code{\link{to_scope}}
}
\concept{modifications}
