% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_features.R
\name{measure_features}
\alias{measure_features}
\alias{net_core}
\alias{net_richclub}
\alias{net_factions}
\alias{net_modularity}
\alias{net_smallworld}
\alias{net_scalefree}
\alias{net_balance}
\title{Measures of network topological features}
\source{
\code{{signnet}} by David Schoch
}
\usage{
net_core(.data, mark = NULL)

net_richclub(.data)

net_factions(.data, membership = NULL)

net_modularity(.data, membership = NULL, resolution = 1)

net_smallworld(.data, method = c("omega", "sigma", "SWI"), times = 100)

net_scalefree(.data)

net_balance(.data)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{mark}{A logical vector the length of the nodes in the network.
This can be created by, among other things, any \verb{node_is_*()} function.}

\item{membership}{A vector of partition membership.}

\item{resolution}{A proportion indicating the resolution scale.
By default 1.}

\item{method}{There are three small-world measures implemented:
\itemize{
\item "sigma" is the original equation from Watts and Strogatz (1998),
\deqn{\frac{\frac{C}{C_r}}{\frac{L}{L_r}}},
where \eqn{C} and \eqn{L} are the observed
clustering coefficient and path length, respectively,
and \eqn{C_r} and \eqn{L_r} are the averages obtained from
random networks of the same dimensions and density.
A \eqn{\sigma > 1} is considered to be small-world,
but this measure is highly sensitive to network size.
\item "omega" (the default) is an update from Telesford et al. (2011),
\deqn{\frac{L_r}{L} - \frac{C}{C_l}},
where \eqn{C_l} is the clustering coefficient for a lattice graph
with the same dimensions.
\eqn{\omega} ranges between 0 and 1,
where 1 is as close to a small-world as possible.
\item "SWI" is an alternative proposed by Neal (2017),
\deqn{\frac{L - L_l}{L_r - L_l} \times \frac{C - C_r}{C_l - C_r}},
where \eqn{L_l} is the average path length for a lattice graph
with the same dimensions.
\eqn{SWI} also ranges between 0 and 1 with the same interpretation,
but where there may not be a network for which \eqn{SWI = 1}.
}}

\item{times}{Integer of number of simulations.}
}
\description{
These functions measure certain topological features of networks:
\itemize{
\item \code{net_core()} measures the correlation between a network
and a core-periphery model with the same dimensions.
\item \code{net_richclub()} measures the rich-club coefficient of a network.
\item \code{net_factions()} measures the correlation between a network
and a component model with the same dimensions.
If no 'membership' vector is given for the data,
\code{node_partition()} is used to partition nodes into two groups.
\item \code{net_modularity()} measures the modularity of a network
based on nodes' membership in defined clusters.
\item \code{net_smallworld()} measures the small-world coefficient for one- or
two-mode networks. Small-world networks can be highly clustered and yet
have short path lengths.
\item \code{net_scalefree()} measures the exponent of a fitted
power-law distribution. An exponent between 2 and 3 usually indicates
a power-law distribution.
\item \code{net_balance()} measures the structural balance index on
the proportion of balanced triangles,
ranging between \code{0} if all triangles are imbalanced and
\code{1} if all triangles are balanced.
}

These \verb{net_*()} functions return a single numeric scalar or value.
}
\section{Modularity}{

Modularity measures the difference between the number of ties within each community
from the number of ties expected within each community in a random graph
with the same degrees, and ranges between -1 and +1.
Modularity scores of +1 mean that ties only appear within communities,
while -1 would mean that ties only appear between communities.
A score of 0 would mean that ties are half within and half between communities,
as one would expect in a random graph.

Modularity faces a difficult problem known as the resolution limit
(Fortunato and Barthélemy 2007).
This problem appears when optimising modularity,
particularly with large networks or depending on the degree of interconnectedness,
can miss small clusters that 'hide' inside larger clusters.
In the extreme case, this can be where they are only connected
to the rest of the network through a single tie.
}

\examples{
net_core(ison_adolescents)
net_core(ison_southern_women)
net_richclub(ison_adolescents)
  net_factions(ison_southern_women)
net_modularity(ison_adolescents, 
  node_in_partition(ison_adolescents))
net_modularity(ison_southern_women, 
  node_in_partition(ison_southern_women))
net_smallworld(ison_brandes)
net_smallworld(ison_southern_women)
net_scalefree(ison_adolescents)
net_scalefree(generate_scalefree(50, 1.5))
net_scalefree(create_lattice(100))
net_balance(ison_marvel_relationships)
}
\references{
\subsection{On core-periphery}{

Borgatti, Stephen P., and Martin G. Everett. 2000.
“Models of Core/Periphery Structures.”
\emph{Social Networks} 21(4):375–95.
\doi{10.1016/S0378-8733(99)00019-2}
}

\subsection{On the rich-club coefficient}{

Zhou, Shi, and Raul J. Mondragon. 2004.
"The Rich-Club Phenomenon in the Internet Topology".
\emph{IEEE Communications Letters}, 8(3): 180-182.
\doi{10.1109/lcomm.2004.823426}
}

\subsection{On modularity}{

Newman, Mark E.J. 2006.
"Modularity and community structure in networks",
\emph{Proceedings of the National Academy of Sciences} 103(23): 8577-8696.
\doi{https://doi.org/10.1073/pnas.0601602103}

Murata, Tsuyoshi. 2010.
"Modularity for Bipartite Networks".
In: Memon, N., Xu, J., Hicks, D., Chen, H. (eds)
\emph{Data Mining for Social Network Data. Annals of Information Systems}, Vol 12.
Springer, Boston, MA.
\doi{10.1007/978-1-4419-6287-4_7}
}

\subsection{On small-worldliness}{

Watts, Duncan J., and Steven H. Strogatz. 1998.
“Collective Dynamics of ‘Small-World’ Networks”.
\emph{Nature} 393(6684):440–42.
\doi{10.1038/30918}

Telesford QK, Joyce KE, Hayasaka S, Burdette JH, Laurienti PJ. 2011.
"The ubiquity of small-world networks".
\emph{Brain Connectivity} 1(5): 367–75.
\doi{10.1089/brain.2011.0038}

Neal, Zachary P. 2017.
"How small is it? Comparing indices of small worldliness".
\emph{Network Science}. 5 (1): 30–44.
\doi{10.1017/nws.2017.5}
}

\subsection{On scale-free networks}{

Barabasi, Albert-Laszlo, and Reka Albert. 1999.
"Emergence of scaling in random networks",
\emph{Science}, 286(5439): 509-512.
\doi{10.1126/science.286.5439.509}

Clauset, Aaron, Cosma Rohilla Shalizi, and Mark E.J. Newman. 2009.
"Power-law distributions in empirical data",
\emph{SIAM Review}, 51(4): 661-703.
\doi{10.1137/070710111}

Stumpf, Michael P.H., and Mason Porter. 2012.
"Critical truths about power laws",
\emph{Science}, 335(6069): 665-666.
\doi{10.1126/science.1216142}

Holme, Petter. 2019.
"Rare and everywhere: Perspectives on scale-free networks",
\emph{Nature Communications}, 10(1): 1016.
\doi{10.1038/s41467-019-09038-8}
}

\subsection{On balance theory}{

Heider, Fritz. 1946.
"Attitudes and cognitive organization".
\emph{The Journal of Psychology}, 21: 107-112.
\doi{10.1080/00223980.1946.9917275}

Cartwright, D., and Frank Harary. 1956.
"Structural balance: A generalization of Heider's theory".
\emph{Psychological Review}, 63(5): 277-293.
\doi{10.1037/h0046049}
}
}
\seealso{
\code{\link[=net_transitivity]{net_transitivity()}} and \code{\link[=net_equivalency]{net_equivalency()}}
for how clustering is calculated

Other measures: 
\code{\link{measure_attributes}},
\code{\link{measure_central_between}},
\code{\link{measure_central_close}},
\code{\link{measure_central_degree}},
\code{\link{measure_central_eigen}},
\code{\link{measure_closure}},
\code{\link{measure_cohesion}},
\code{\link{measure_diffusion_infection}},
\code{\link{measure_diffusion_net}},
\code{\link{measure_diffusion_node}},
\code{\link{measure_heterogeneity}},
\code{\link{measure_hierarchy}},
\code{\link{measure_holes}},
\code{\link{measure_periods}},
\code{\link{measure_properties}},
\code{\link{member_diffusion}}
}
\concept{measures}
