% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cayleymenger.R
\name{cayleymenger}
\alias{cayleymenger}
\title{Cayley-Menger Determinant}
\usage{
cayleymenger(data)
}
\arguments{
\item{data}{an \eqn{(n\times p)} matrix of row-stacked observations.}
}
\value{
a list containing\describe{
\item{det}{determinant value.}
\item{vol}{volume attained from the determinant.}
}
}
\description{
Cayley-Menger determinant is a formula of a \eqn{n}-dimensional simplex 
with respect to the squares of all pairwise distances of its vertices.
}
\examples{
## USE 'IRIS' DATASET
data(iris)
X = as.matrix(iris[,1:4])

## COMPUTE CAYLEY-MENGER DETERMINANT
#  since k=4 < n=149, it should be zero.
cayleymenger(X)

}
