% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_railway.R
\name{esp_get_railway}
\alias{esp_get_railway}
\title{Get \code{sf} lines and points with the railways of Spain}
\source{
IGN data via a custom CDN (see
\url{https://github.com/rOpenSpain/mapSpain/tree/sianedata}).
}
\usage{
esp_get_railway(
  year = Sys.Date(),
  epsg = "4258",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  spatialtype = "line"
)
}
\arguments{
\item{year}{Release year.}

\item{epsg}{projection of the map: 4-digit \href{https://epsg.io/}{EPSG code}.
One of:
\itemize{
\item \code{"4258"}: ETRS89
\item \code{"4326"}: WGS84
\item \code{"3035"}: ETRS89 / ETRS-LAEA
\item \code{"3857"}: Pseudo-Mercator
}}

\item{cache}{A logical whether to do caching. Default is \code{TRUE}. See
\strong{About caching}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source file.}

\item{cache_dir}{A path to a cache directory. See \strong{About caching}.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}

\item{spatialtype}{Spatial type of the output. Use \code{"line"}
for extracting the railway as lines and \code{"point"} for extracting
stations.}
}
\value{
A \code{sf} line or point object.
}
\description{
Loads a \code{sf} lines or point object representing the nodes and railway
lines of Spain.
}
\section{About caching}{
You can set your \code{cache_dir} with \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.

Sometimes cached files may be corrupt. On that case, try re-downloading
the data setting \code{update_cache = TRUE}.

If you experience any problem on download, try to download the
corresponding .geojson file by any other method and save it on your
\code{cache_dir}. Use the option \code{verbose = TRUE} for debugging the API query.
}

\examples{
\donttest{

provs <- esp_get_prov()
ccaa <- esp_get_ccaa()

# Railways
rails <- esp_get_railway()

# Stations
stations <- esp_get_railway(spatialtype = "point")

# Map

library(tmap)

tm_shape(provs, bbox = c(-7.5, 38, -2.5, 41)) +
  tm_polygons(col = "grey99", border.col = "grey50") +
  tm_shape(ccaa) +
  tm_borders("black") +
  tm_shape(rails) +
  tm_lines("tipo",
    legend.col.show = FALSE, lwd = 3,
    palette = "viridis"
  ) +
  tm_shape(stations) +
  tm_symbols("red", size = .3, alpha = 0.5, shape = 19)
}
}
\seealso{
Other infrastructure: 
\code{\link{esp_get_roads}()}
}
\concept{infrastructure}
