% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{add_draw_control}
\alias{add_draw_control}
\title{Add a draw control to a map}
\usage{
add_draw_control(
  map,
  position = "top-left",
  freehand = FALSE,
  simplify_freehand = FALSE,
  orientation = "vertical",
  ...
)
}
\arguments{
\item{map}{A map object created by the \code{mapboxgl} or \code{maplibre} functions.}

\item{position}{A string specifying the position of the draw control.
One of "top-right", "top-left", "bottom-right", or "bottom-left".}

\item{freehand}{Logical, whether to enable freehand drawing mode. Default is FALSE.}

\item{simplify_freehand}{Logical, whether to apply simplification to freehand drawings. Default is FALSE.}

\item{orientation}{A string specifying the orientation of the draw control.
Either "vertical" (default) or "horizontal".}

\item{...}{Additional named arguments. See \url{https://github.com/mapbox/mapbox-gl-draw/blob/main/docs/API.md#options} for a list of options.}
}
\value{
The modified map object with the draw control added.
}
\description{
Add a draw control to a map
}
\examples{
\dontrun{
library(mapgl)

mapboxgl(
    style = mapbox_style("streets"),
    center = c(-74.50, 40),
    zoom = 9
) |>
    add_draw_control()
}
}
