% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quickview.R
\name{mapboxgl_view}
\alias{mapboxgl_view}
\title{Quick visualization of geometries with Mapbox GL}
\usage{
mapboxgl_view(
  data,
  column = NULL,
  n = NULL,
  style = mapbox_style("light"),
  ...
)
}
\arguments{
\item{data}{An sf object to visualize}

\item{column}{The name of the column to visualize. If NULL (default), geometries are shown with default styling.}

\item{n}{Number of quantile breaks for numeric columns. If specified, uses step_expr() instead of interpolate().}

\item{style}{The Mapbox style to use. Defaults to mapbox_style("light").}

\item{...}{Additional arguments passed to mapboxgl()}
}
\value{
A Mapbox GL map object
}
\description{
This function provides a quick way to visualize sf geometries using Mapbox GL JS.
It automatically detects the geometry type and applies appropriate styling.
}
\examples{
\dontrun{
library(sf)
nc <- st_read(system.file("shape/nc.shp", package = "sf"))

# Basic view
mapboxgl_view(nc)

# View with column visualization
mapboxgl_view(nc, column = "AREA")

# View with quantile breaks
mapboxgl_view(nc, column = "AREA", n = 5)
}
}
