% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_indicator.R
\name{calc_indicators}
\alias{calc_indicators}
\title{Compute specific indicators}
\usage{
calc_indicators(x, indicators, ...)
}
\arguments{
\item{x}{A biodiversity portfolio object constructed via
\code{init_portfolio()}}

\item{indicators}{A character vector indicating the requested indicators. All
specified indicators must be supported by the package. You can use
\code{available_indicators()} to get more information, e.g. additional
required arguments and their default values, about the supported indicators}

\item{...}{Additional arguments required for the requested indicators. Check
\code{available_indicators()} to learn more about the supported indicators
and their arguments.}
}
\value{
The sf portfolio object \code{x} with additional nested list column per
requested indicator.
}
\description{
With \code{calc_indicators()} specific biodiversity indicators
can be calculated. A requirment is that the ressources that
are mandatory inputs for the requested indicators are available
locally. Multiple indicators and their respective additional
arguments can be supplied. You can check available indicators and
their requirement via \code{available_indicators()}, but
the function will also gracefully inform you about any misspecifications.
}
\keyword{function}
