% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/portfolio.R
\name{portfolio}
\alias{portfolio}
\alias{write_portfolio}
\alias{portfolio_long}
\alias{portfolio_wide}
\title{Portfolio methods}
\usage{
write_portfolio(x, dsn, format = c("long", "wide"), overwrite = FALSE, ...)

portfolio_long(x, indicators = NULL, drop_geoms = FALSE)

portfolio_wide(x, indicators = NULL, drop_geoms = FALSE)
}
\arguments{
\item{x}{A portfolio object processed with \code{mapme.biodiversity}.}

\item{dsn}{A file path for the output file.}

\item{format}{A character indicating if data should be written in long or
wide format.}

\item{overwrite}{A logical indicating if the output file should be
overwritten if it exists.}

\item{...}{Additional arguments supplied to \code{st_write()}}

\item{indicators}{If NULL (the default), all indicator columns will be detected
and transformed automatically. If a character vector is supplied, only
those indicators will be transformed.}

\item{drop_geoms}{A logical, indicating if geometries should be dropped.}
}
\value{
\code{write_portfolio()} returns \code{dsn}, invisibly.

\code{portfolio_long()} returns the portfolio object in long-format.

\code{portfolio_wide()} returns the portfolio object in wide-format.
}
\description{
\code{write_portfolio()} writes a processed biodiversity portfolio to disk.
In order to ensure interoperability with other geospatial software, the
data has to be transformed to either long- or wide-format. With the long
format, geometries will be repeated thus possibly resulting in
a large file size. With the wide-format, indicators will be added
to the portfolio as columns without repeating the geometries, but potentially
resulting in a large number of columns

\code{portfolio_long()} transforms a portfolio to long-format, potentially
dropping geometries in the process.

\code{portfolio_wide()} transforms a portfolio to wide-format, potentially
dropping geometries in the process.
}
