% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_temperature_min_wc.R
\name{temperature_min_wc}
\alias{temperature_min_wc}
\alias{calc_temperature_min_wc}
\title{Calculate minimum temperature statistics based on WorldClim}
\usage{
calc_temperature_min_wc(engine = "extract", stats = "mean")
}
\arguments{
\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}

\item{stats}{Function to be applied to compute statistics for polygons either
single or multiple inputs as character. Supported statistics are: "mean",
"median", "sd", "min", "max", "sum" "var".}
}
\value{
A function that returns a tibble with a column for minimum
temperature statistics (in °C).
}
\description{
This function allows to efficiently calculate minimum temperature statistics
from Worldclim for polygons. For each polygon, the desired statistic/s (min,
max, sum, mean, median, sd or var) is/are returned.
}
\details{
The required resources for this indicator are:
\itemize{
\item minimum temperature layer from \link{worldclim_min_temperature}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(get_worldclim_min_temperature(years = 2018)) \%>\%
  calc_indicators(
    calc_temperature_min_wc(
      engine = "extract",
      stats = c("mean", "median")
    )
  ) \%>\%
  portfolio_long()

aoi
}
}
\keyword{indicator}
