% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial-utils.R
\name{make_footprints}
\alias{make_footprints}
\title{Create footprints for vector or raster data sets}
\usage{
make_footprints(
  srcs = NULL,
  filenames = if (inherits(srcs, "sf")) basename(srcs[["source"]]) else basename(srcs),
  what = c("vector", "raster"),
  oo = NULL,
  co = NULL,
  precision = 1e+05
)
}
\arguments{
\item{srcs}{A character vector with GDAL readable paths to either vector
or raster sources, then internal footprint functions are called, or an
sf object which will be appended for filenames and potential options.}

\item{filenames}{A character vector indicating the filenames of the source
data sets if they were written to a destination. Defaults to \code{basename(srcs)}
in case of character type or \code{basename(srcs[["source"]])} in case of
an sf object.}

\item{what}{A character vector indicating if the files are vector or raster
files.}

\item{oo}{Either a list or a character vector with opening options (-oo)
of the respective GDAL driver. A list must have equal length of the
input sources, a vector will be recycled.}

\item{co}{Either a list or a character vector with creation options (-co)
of the respective GDAL driver. A list must have equal length of the
input sources, a vector will be recycled.}

\item{precision}{A numeric indicating the precision of coordinates when
a binary round-trip is done (see \code{?sf::st_as_binary()}).}
}
\value{
An sf object with a the files sources and the geometry indicating
their spatial footprint.
}
\description{
With this function you can create footprints for vector or raster datasets.
Specify a character vector of GDAL readable sources of either vector
or raster type. Internally, GDAL will be used to create an sf object
with a single column indicating the source and the geometry indicating
the bounding box of the respective source.
Note, the performance for remote sources is dependent on your connection to
the server. If you have other means to create footprints in your resource
function (e.g. by using the output \code{{rstac::items_bbox()}}) you should prefer
those means over this function for remote files.
}
\examples{

# a vector resource
# requires GDAL >= 3.7.0
if (FALSE) {
  vec <- system.file("shape/nc.shp", package = "sf")
  make_footprints(vec, what = "vector")
}

# a raster resource
ras <- system.file("ex/elev.tif", package = "terra")
make_footprints(ras, what = "raster")
}
\keyword{utils}
