% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nelson_et_al.R
\name{nelson_et_al}
\alias{nelson_et_al}
\alias{get_nelson_et_al}
\title{Accessibility to Cities layer}
\source{
\url{https://figshare.com/articles/dataset/Travel_time_to_cities_and_ports_in_the_year_2015/7638134/3}
}
\usage{
get_nelson_et_al(ranges = "20k_50k")
}
\arguments{
\item{ranges}{A character vector indicating one or more ranges
to download.}
}
\value{
A function that returns an \code{sf} footprint object.
}
\description{
This resource is published by Weiss et al. (2018) "A global map of travel
time to cities to assess inequalities in accessibility in 2015" on journal
nature. Accessibility is the ease with which larger cities can be reached
from a certain location. This resource represents the travel time to major
cities in the year 2015. Encoded as minutes, representing the time needed
to reach that particular cell from nearby city of target population range.
The following ranges to nearby cities are available:
\itemize{
\item "5k_10k"
\item "10k_20k"
\item "20k_50k"
\item "50k_100k"
\item "100k_200k"
\item "200k_500k"
\item "500k_1mio"
\item "1mio_5mio"
\item "50k_50mio"
\item "5k_110mio"
\item "20k_110mio"
\item "5mio_50mio"
}
}
\note{
Note, that the 'figshare' server applies a rather restrictive rate limit
thus frequently resulting in opaque error codes (see \url{https://github.com/mapme-initiative/mapme.biodiversity/issues/308}).
Please set GDAL configuration options to sensible values in case
you are running into this issue, e.g.: \code{Sys.setenv("GDAL_HTTP_MAX_RETRY" = "5", "GDAL_HTTP_RETRY_DELAY" = "15")}.
}
\references{
Weiss, D. J., Nelson, A., Gibson, H. S., Temperley, W., Peedell,
S., Lieber, A., … & Gething, P. W. (2018). A global map of travel time to cities
to assess inequalities in accessibility in 2015. Nature, 553(7688), 333-336.
}
\keyword{resource}
