% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping.R
\name{cf}
\alias{cf}
\title{Construct a \code{factor} from one or more vectors}
\usage{
cf(x, ..., sep = ";")
}
\arguments{
\item{x}{An atomic vector.}

\item{...}{Additional atomic vectors (optional).}

\item{sep}{A \code{character} to use as a separator when forming a compound value
(default ';').}
}
\value{
A \code{factor}.
}
\description{
A \code{factor} is constructed from one or more atomic vectors.  If more than
one atomic vector is supplied, then a compound value is constructed by
concatenating the values together. The order of the levels is the natural
order in which the values appear.
}
\examples{
x <- c("A", "B", "A")
y <- c(2, 5, 7)
cf(x, y)
mapping(cf(x, y), c("X", "Y", "Z"))
}
