% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_seq.R
\name{make_seq_mappoly}
\alias{make_seq_mappoly}
\alias{print.mappoly.sequence}
\alias{plot.mappoly.sequence}
\title{Create a sequence of markers}
\usage{
make_seq_mappoly(input.obj, arg = NULL, data.name = NULL, genomic.info = NULL)

\method{print}{mappoly.sequence}(x, ...)

\method{plot}{mappoly.sequence}(x, ...)
}
\arguments{
\item{input.obj}{an object of one of the following classes:
\code{mappoly.data}, \code{mappoly.map}, \code{mappoly.group}, \code{mappoly.unique.seq},
\code{mappoly.pcmap} or \code{mappoly.pcmap3d}}

\item{arg}{can be one of the following objects: i) a string 'all',
resulting in a sequence with all markers in the raw data; ii) a
string or a vector of strings \code{'seqx'}, where \code{x}
is the sequence (\code{x=0} indicates unassigned markers); iii) a
\code{vector} of integers specifying which markers comprise the
sequence; iv) an integer representing linkage group if 
\code{input.object} has class \code{mappoly.group}; or v) NULL if 
\code{input.object} has class \code{mappoly.pcmap}, \code{mappoly.pcmap3d} or 
\code{mappoly.unique.seq}}

\item{data.name}{name of the object of class \code{mappoly.data}}

\item{genomic.info}{optional argument applied for \code{mappoly.group} objects only. This argument can be \code{NULL},
or can hold the numeric combination of sequences from genomic information to be used when making the sequences.
When \code{genomic.info = NULL} (default), the function returns a sequence containing all markers defined 
by the grouping function. When \code{genomic.info = 1}, the function returns a sequence with markers
that matched the intersection between grouping function and genomic information, considering the sequence
from genomic information that holds the maximum number of markers matching the group;
when \code{genomic.info = c(1,2)}, the function returns a sequence with markers
that matched the intersection between grouping function and genomic information, considering two sequences
from genomic information that presented the maximum number of markers matching the group; and so on.}

\item{x}{an object of the class \code{mappoly.sequence}}

\item{...}{currently ignored}
}
\value{
An object of class \code{mappoly.sequence}, which is a
    list containing the following components:
    \item{seq.num}{a \code{vector} containing the (ordered) indices
        of markers in the sequence, according to the input file}
    \item{seq.phases}{a \code{list} with the linkage phases between
        markers in the sequence, in corresponding positions. \code{-1}
        means that there are no defined linkage phases}
    \item{seq.rf}{a \code{vector} with the recombination
        frequencies between markers in the sequence. \code{-1} means
        that there are no estimated recombination frequencies}
    \item{loglike}{log-likelihood of the corresponding linkage
        map}
    \item{data.name}{name of the object of class
        \code{mappoly.data} with the raw data}
    \item{twopt}{name of the object of class \code{mappoly.twopt}
        with the 2-point analyses. \code{-1} means that the twopt
        estimates were not computed}
}
\description{
Makes a sequence of markers based on an object of another class.
}
\examples{
    all.mrk<-make_seq_mappoly(hexafake, 'all')
    seq1.mrk<-make_seq_mappoly(hexafake, 'seq1')
    plot(seq1.mrk)
    some.mrk.pos<-c(1,4,28,32,45)
    (some.mrk.1<-make_seq_mappoly(hexafake, some.mrk.pos))
    plot(some.mrk.1)

}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \url{https://doi.org/10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}, with modifications by Gabriel Gesteira, \email{gabrielgesteira@usp.br}
}
